package com.biz.crm.business.common.auth.sdk.dto;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 外部系统信息
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.28 19:04
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UrlAddressDto extends TenantFlagOpVo {


    private static final long serialVersionUID = -1210924470560859728L;

    @ApiModelProperty("系统账号")
    private String userName;

    @ApiModelProperty("系统名称")
    private String fullName;

    @ApiModelProperty("url地址")
    private String url;

    @ApiModelProperty("移动端url地址")
    private String mobileUrl;

    @ApiModelProperty("账号ID")
    private String accessId;

    @ApiModelProperty("账号")
    private String accessKey;

    @ApiModelProperty("密匙")
    private String secretKey;

    @ApiModelProperty("环境")
    private String environment;

    @ApiModelProperty("业务标记")
    private String businessKey;

    @ApiModelProperty("系统缓存时间/分钟")
    private Integer cacheTime;

    @ApiModelProperty("Redis缓存时间/小时")
    private Integer cacheRedisTime;

    @ApiModelProperty("签名过期时间/分钟")
    private Integer signExpireDate;

    @ApiModelProperty("访问次数限制")
    private Integer accessTimesMax;

    @ApiModelProperty("token刷新key")
    private String refreshKey;

    @ApiModelProperty("配置租户编码")
    private String actualTenantCode;

    @ApiModelProperty("是否所有接口权限")
    private String isAll;

    @ApiModelProperty("接口类型权限")
    private List<UrlAddressAuthorityDto> interfaceList;
}
