/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.sdk.utils;

import cn.hutool.core.util.XmlUtil;
import com.biz.crm.business.common.auth.sdk.annotation.SapFormField;
import com.biz.crm.business.common.auth.sdk.annotation.XmlFieldProperty;
import com.biz.crm.business.common.auth.sdk.annotation.XmlRootProperty;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class SapUtil {
    private static final Logger log = LoggerFactory.getLogger(SapUtil.class);
    private static final ThreadLocal<String> logMap = new ThreadLocal();
    private static final RestTemplate restTemplate = new RestTemplate();
    public static final String REQUEST_PLACEHOLDER = "\u8bf7\u6c42\u53c2\u6570\u5360\u4f4d\u7b26";

    public static void setUpLog(String prefix) {
        logMap.set(prefix);
    }

    public static <T, R> R send(String url, T param, String username, String password) {
        long tid = Thread.currentThread().getId();
        log.info("tid:{},sap\u5165\u53c2url:{}", (Object)tid, (Object)url);
        log.info("tid:{},sap\u5165\u53c2param:{}", (Object)tid, param);
        HttpHeaders headers = new HttpHeaders();
        SapUtil.setToken(headers, username, password);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity exchange = null;
        try {
            exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<R>(){}, new Object[0]);
        }
        catch (RestClientException e) {
            SapUtil.storeLog(url, String.valueOf(param), String.valueOf(e.getCause()));
            throw new RuntimeException(e);
        }
        log.info("tid:{},sap\u54cd\u5e94result:{}", (Object)tid, (Object)exchange);
        SapUtil.storeLog(url, String.valueOf(param), String.valueOf(exchange.getBody()));
        Object body = exchange.getBody();
        log.info("tid:{},body:{}", (Object)tid, (Object)exchange);
        Assert.notNull((Object)body, (String)"\u7f3a\u5931\u8fd4\u56de\u6570\u636e");
        return (R)body;
    }

    public static <T, R> R sendConvertParam(String url, T param, Class<T> clazz, String username, String password) {
        long tid = Thread.currentThread().getId();
        log.info("tid:{},sap\u5165\u53c2url:{}", (Object)tid, (Object)url);
        log.info("tid:{},sap\u5165\u53c2param:{}", (Object)tid, param);
        String p = SapUtil.convertParam(param, clazz);
        HttpHeaders headers = new HttpHeaders();
        SapUtil.setToken(headers, username, password);
        HttpEntity httpEntity = new HttpEntity((Object)p, (MultiValueMap)headers);
        ResponseEntity exchange = null;
        try {
            exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<R>(){}, new Object[0]);
        }
        catch (RestClientException e) {
            SapUtil.storeLog(url, String.valueOf(param), String.valueOf(e.getCause()));
            throw new RuntimeException(e);
        }
        log.info("tid:{},sap\u54cd\u5e94result:{}", (Object)tid, (Object)exchange);
        SapUtil.storeLog(url, p, String.valueOf(exchange.getBody()));
        Object body = exchange.getBody();
        log.info("tid:{},body:{}", (Object)tid, (Object)exchange);
        Assert.notNull((Object)body, (String)"\u7f3a\u5931\u8fd4\u56de\u6570\u636e");
        return (R)body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendParam(String url, String param, String username, String password) {
        String string;
        String prefix = logMap.get();
        prefix = !StringUtils.hasText((String)prefix) ? "" : prefix;
        ResponseEntity exchange = null;
        try {
            log.info(prefix + "sap\u63a5\u53e3sap\u5165\u53c2url:{}", (Object)url);
            log.info(prefix + "sap\u5165\u53c2:{}", (Object)param);
            HttpHeaders headers = new HttpHeaders();
            SapUtil.setToken(headers, username, password);
            HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            log.info(prefix + "sap\u54cd\u5e94:{}", (Object)exchange);
            String body = (String)exchange.getBody();
            Assert.hasText((String)body, (String)"\u7f3a\u5931\u8fd4\u56de\u6570\u636e");
            string = body;
            logMap.remove();
        }
        catch (Throwable throwable) {
            logMap.remove();
            SapUtil.storeLog(url, param, String.valueOf(exchange));
            throw throwable;
        }
        SapUtil.storeLog(url, param, String.valueOf(exchange));
        return string;
    }

    public static <T> String sendParamByClass(String url, String templateXml, T t, Class<T> tClazz, String username, String password) {
        StringBuilder paramXml = new StringBuilder();
        SapUtil.generateXmlByClass(t, tClazz, paramXml, "");
        String requestXml = templateXml.replace(REQUEST_PLACEHOLDER, paramXml.toString());
        String response = SapUtil.sendParam(url, requestXml, username, password);
        return response;
    }

    public static <T, R> R sendParamByClass(String url, String templateXml, T t, Class<T> tClazz, Class<R> rClazz, String tag, String username, String password) {
        Validate.notBlank((CharSequence)tag, (String)"\u7ed3\u679c\u9009\u53d6\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder paramXml = new StringBuilder();
        SapUtil.generateXmlByClass(t, tClazz, paramXml, "");
        String requestXml = templateXml.replace(REQUEST_PLACEHOLDER, paramXml.toString());
        String response = SapUtil.sendParam(url, requestXml, username, password);
        return SapUtil.string2Class(response, tag, rClazz, true);
    }

    public static <T, R> List<R> sendParamByClassBatch(String url, String templateXml, T t, Class<T> tClazz, Class<R> rClazz, String tag, String username, String password) {
        Validate.notBlank((CharSequence)tag, (String)"\u7ed3\u679c\u9009\u53d6\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder paramXml = new StringBuilder();
        SapUtil.generateXmlByClass(t, tClazz, paramXml, "");
        String requestXml = templateXml.replace(REQUEST_PLACEHOLDER, paramXml.toString());
        String response = SapUtil.sendParam(url, requestXml, username, password);
        return SapUtil.string2ClassBatch(response, tag, rClazz);
    }

    public static <R> List<R> string2ClassBatch(String response, String tag, Class<R> clazz) {
        Pattern pattern = Pattern.compile("<" + tag + ">[\\s\\S]*?</" + tag + ">");
        Matcher matcher = pattern.matcher(response);
        ArrayList<R> reList = new ArrayList<R>();
        while (matcher.find()) {
            reList.add(SapUtil.string2Class(matcher.group(), tag, clazz, false));
        }
        return reList;
    }

    public static <R> R string2Class(String response, String tag, Class<R> clazz, boolean useMatch) {
        String matchResponse = "";
        if (useMatch) {
            Pattern pattern = Pattern.compile("<" + tag + ">[\\s\\S]*?</" + tag + ">");
            Matcher matcher = pattern.matcher(response);
            while (matcher.find()) {
                matchResponse = matcher.group();
            }
        } else {
            matchResponse = response;
        }
        Document document = XmlUtil.parseXml((String)matchResponse);
        Element rootElement = XmlUtil.getRootElement((Document)document);
        HashMap<String, NodeData> prefix2Data = new HashMap<String, NodeData>();
        Stack<Node> nodeStack = new Stack<Node>();
        NodeList nodeList = rootElement.getChildNodes();
        HashMap<Node, String> node2Path = new HashMap<Node, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node2Path.put(node, node.getLocalName());
            nodeStack.push(nodeList.item(i));
        }
        while (!nodeStack.isEmpty()) {
            Node node = (Node)nodeStack.pop();
            String currentNodePath = (String)node2Path.get(node);
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node childNode = children.item(i);
                    nodeStack.push(children.item(i));
                    if (childNode.hasChildNodes()) {
                        node2Path.put(childNode, currentNodePath + "." + childNode.getLocalName());
                        continue;
                    }
                    node2Path.put(childNode, currentNodePath);
                }
                continue;
            }
            String parentPath = (String)node2Path.get(node.getParentNode());
            if (null != parentPath && prefix2Data.containsKey(parentPath)) {
                NodeData nodeData = (NodeData)prefix2Data.get(parentPath);
                String[] currentPathSplit = currentNodePath.split(".");
                String currentLastPath = currentPathSplit[currentNodePath.length() - 1];
                if (prefix2Data.containsKey(currentNodePath)) {
                    nodeData.getMultiData().get(0).put(currentLastPath, ((NodeData)prefix2Data.get(currentNodePath)).getSingleData());
                    prefix2Data.remove(currentNodePath);
                }
                if (nodeData.getMultiData().getLast().containsKey(currentLastPath)) {
                    HashMap<String, String> newMultiData = new HashMap<String, String>();
                    newMultiData.put(currentLastPath, node.getTextContent());
                    nodeData.getMultiData().add(newMultiData);
                    continue;
                }
                nodeData.getMultiData().getLast().put(currentLastPath, node.getTextContent());
                continue;
            }
            if (prefix2Data.containsKey(currentNodePath)) {
                String[] currentPathSplit = currentNodePath.split(".");
                String currentLastPath = currentPathSplit[currentNodePath.length() - 1];
                LinkedList<Map<String, String>> multiData = new LinkedList<Map<String, String>>();
                HashMap<String, String> multiDataItem1 = new HashMap<String, String>();
                multiDataItem1.put(currentLastPath, ((NodeData)prefix2Data.get(currentNodePath)).getSingleData());
                multiData.add(multiDataItem1);
                prefix2Data.remove(currentNodePath);
                HashMap<String, String> multiDataItem2 = new HashMap<String, String>();
                multiDataItem2.put(currentLastPath, node.getTextContent());
                multiData.add(multiDataItem2);
                NodeData nodeData = new NodeData(multiData);
                prefix2Data.put(parentPath, nodeData);
                continue;
            }
            NodeData nodeData = new NodeData(node.getTextContent());
            prefix2Data.put(currentNodePath, nodeData);
        }
        R obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            log.info("\u5b9e\u4f8b\u5316\u5931\u8d25");
            return null;
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            SapFormField sapFormField = field.getAnnotation(SapFormField.class);
            if (null == sapFormField) continue;
            try {
                if (sapFormField.list()) {
                    field.setAccessible(true);
                    List<Object> dataList = SapUtil.nodeData2DataList(prefix2Data, sapFormField);
                    field.set(obj, dataList);
                    continue;
                }
                NodeData data = (NodeData)prefix2Data.get(sapFormField.path());
                if (null == data) continue;
                SapUtil.setData(field, data.getSingleData(), obj);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    private static void setData(Field field, String data, Object obj) throws IllegalAccessException {
        field.setAccessible(true);
        if (null == data) {
            return;
        }
        if (field.getType() == Integer.class) {
            field.set(obj, Integer.valueOf(data.trim()));
        }
        if (field.getType() == BigDecimal.class) {
            BigDecimal b = null;
            try {
                b = new BigDecimal(data.trim());
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u8d4b\u503c\u5f02\u5e38:", (Throwable)e);
                b = BigDecimal.ZERO;
            }
            field.set(obj, b);
        }
        if (field.getType() == String.class) {
            field.set(obj, data.trim());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<Object> nodeData2DataList(Map<String, NodeData> prefix2Data, SapFormField parentSapFormField) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        NodeData nodeData = prefix2Data.get(parentSapFormField.path());
        Field[] fields = parentSapFormField.itemClazz().getDeclaredFields();
        HashMap<Field, SapFormField> field2SapFormField = new HashMap<Field, SapFormField>();
        for (Field field : fields) {
            SapFormField sapFormField = field.getAnnotation(SapFormField.class);
            if (null == sapFormField) continue;
            field2SapFormField.put(field, sapFormField);
        }
        if (null == nodeData) {
            Object obj = null;
            try {
                void var9_15;
                obj = parentSapFormField.itemClazz().newInstance();
                Field[] fieldArray = fields;
                int n = fieldArray.length;
                boolean bl = false;
                while (var9_15 < n) {
                    NodeData data;
                    Field field = fieldArray[var9_15];
                    SapFormField sapFormField = (SapFormField)field2SapFormField.get(field);
                    if (null != sapFormField && null != (data = prefix2Data.get(parentSapFormField.path() + "." + sapFormField.path()))) {
                        SapUtil.setData(field, data.getSingleData(), obj);
                    }
                    ++var9_15;
                }
                dataList.add(obj);
            }
            catch (Exception exception) {
                log.error("sap\u5de5\u5177\u7c7b\u8fd4\u56de\u751f\u6210\u5b9e\u4f8b\u9519\u8bef");
            }
        } else {
            for (Map map : nodeData.getMultiData()) {
                Object obj = null;
                try {
                    obj = parentSapFormField.itemClazz().newInstance();
                    for (Field field : fields) {
                        String data;
                        SapFormField sapFormField = (SapFormField)field2SapFormField.get(field);
                        if (null == sapFormField || null == (data = (String)map.get(sapFormField.path()))) continue;
                        SapUtil.setData(field, data, obj);
                    }
                    dataList.add(obj);
                }
                catch (Exception exception) {
                    log.error("sap\u5de5\u5177\u7c7b\u8fd4\u56de\u751f\u6210\u5b9e\u4f8b\u9519\u8bef");
                }
            }
        }
        return dataList;
    }

    public static String sendParamBody(String url, String methodName, String methodNameSpace, String param, String username, String password) {
        String p = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:cass=\"http://cofco.com/mm/cass\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <" + methodName + " " + methodNameSpace + ">\n         <I_REQUEST>\n" + param + "         </I_REQUEST>\n      </" + methodName + ">\n   </soapenv:Body>\n</soapenv:Envelope>";
        long tid = Thread.currentThread().getId();
        log.info("tid:{},sap\u5165\u53c2url:{}", (Object)tid, (Object)url);
        log.info("tid:{},sap\u5165\u53c2param:{}", (Object)tid, (Object)p);
        HttpHeaders headers = new HttpHeaders();
        SapUtil.setToken(headers, username, password);
        HttpEntity httpEntity = new HttpEntity((Object)p, (MultiValueMap)headers);
        ResponseEntity exchange = null;
        try {
            exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            SapUtil.storeLog(url, p, String.valueOf(e.getCause()));
            throw new RuntimeException(e);
        }
        log.info("tid:{},sap\u54cd\u5e94result:{}", (Object)tid, (Object)exchange);
        SapUtil.storeLog(url, p, String.valueOf(exchange.getBody()));
        String body = (String)exchange.getBody();
        log.info("tid:{},body:{}", (Object)tid, (Object)exchange);
        Assert.hasText((String)body, (String)"\u7f3a\u5931\u8fd4\u56de\u6570\u636e");
        return body;
    }

    private static void setToken(HttpHeaders headers, String username, String password) {
        headers.set("Content-type", "text/xml; charset=utf-8");
        headers.set("Accept", "text/xml; charset=utf-8");
        headers.add("authorization", "Basic " + HttpHeaders.encodeBasicAuth((String)username, (String)password, null));
    }

    public static List<Map<String, String>> sendMap(String url, String targetNameSpace, String methodName, String methodNameSpace, Map<String, Object> param, String receiveTag, String username, String password) {
        StringBuilder p = new StringBuilder();
        p.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:cass=\"").append(targetNameSpace).append("\">");
        p.append("<soapenv:Header/>");
        p.append("<soapenv:Body>");
        p.append("<").append(methodName);
        if (StringUtils.hasText((String)methodNameSpace)) {
            p.append(" ").append(methodNameSpace);
        }
        p.append(">");
        StringBuilder sb = new StringBuilder();
        SapUtil.mapToXML(param, sb);
        p.append((CharSequence)sb);
        p.append("</").append(methodName).append(">");
        p.append("</soapenv:Body>");
        p.append("</soapenv:Envelope>");
        String result = SapUtil.sendParam(url, p.toString(), username, password);
        return SapUtil.resolveDocument(receiveTag, result);
    }

    public static <T> List<Map<String, String>> sendMap(String url, T t, Class<T> clazz, String tagName, String username, String password) {
        String result = SapUtil.sendParam(url, SapUtil.convertParam(t, clazz), username, password);
        return SapUtil.resolveDocument(tagName, result);
    }

    public static <T, R> List<R> sendMapBatch(String url, T t, String tagName, Class<R> returnClass, Class<T> tClass, String username, String password) {
        String result = SapUtil.sendParam(url, SapUtil.convertParam(t, tClass), username, password);
        List<Map<String, String>> key2DataList = SapUtil.resolveDocument(tagName, result);
        return SapUtil.setResponseDataBatch(key2DataList, returnClass);
    }

    public static <T, R> R sendMap(String url, T t, String tagName, Class<R> returnClass, Class<T> tClass, String username, String password) {
        String result = SapUtil.sendParam(url, SapUtil.convertParam(t, tClass), username, password);
        List<Map<String, String>> key2DataList = SapUtil.resolveDocument(tagName, result);
        if (CollectionUtils.isEmpty(key2DataList)) {
            return null;
        }
        return SapUtil.setResponseData(key2DataList.get(0), returnClass);
    }

    public static List<Map<String, String>> resolveDocument(String tagName, String result) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Document document = XmlUtil.parseXml((String)result);
        Element rootElement = XmlUtil.getRootElement((Document)document);
        NodeList nodeList = rootElement.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            NodeList childNodes = item.getChildNodes();
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node tmp = childNodes.item(j);
                if (!StringUtils.hasText((String)tmp.getLocalName())) continue;
                tmpMap.put(tmp.getLocalName(), tmp.getTextContent().trim());
            }
            if (CollectionUtils.isEmpty(tmpMap)) continue;
            list.add(tmpMap);
        }
        return list;
    }

    public static <T> void generateXmlByClass(T t, Class<T> clazz, StringBuilder p, String basicName) {
        if (String.class == clazz || Integer.class == clazz || Long.class == clazz) {
            p.append("<").append(basicName).append(">");
            p.append(t);
            p.append("</" + basicName + ">");
            return;
        }
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, List<Pair<String, Object>>> dataGroupByPrefix = new HashMap<String, List<Pair<String, Object>>>();
        for (Field field : fields) {
            XmlFieldProperty anno = field.getAnnotation(XmlFieldProperty.class);
            if (anno == null) continue;
            String name = anno.name();
            Assert.hasText((String)name, (String)(field.getName() + "\u7f3a\u5931\u5c5e\u6027\u540d\u79f0"));
            try {
                field.setAccessible(true);
                Object data = field.get(t);
                SapUtil.appendField(p, dataGroupByPrefix, anno, name, data);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
                e.printStackTrace();
            }
        }
        SapUtil.appendMap(p, dataGroupByPrefix);
    }

    public static <T> void generateXmlBatchByClass(List<T> dataList, Class<T> clazz, StringBuilder p, String basicName) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        Validate.notNull(clazz, (String)"\u660e\u7ec6Class\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (T t : dataList) {
            SapUtil.generateXmlByClass(t, clazz, p, basicName);
        }
    }

    public static <T> String convertParam(T t, Class<T> clazz) {
        StringBuilder p = new StringBuilder();
        XmlRootProperty clazzAnno = clazz.getAnnotation(XmlRootProperty.class);
        Assert.notNull((Object)clazzAnno, (String)"\u7c7b\u4e0a\u7f3a\u5931\u3010XmlRootProperty\u3011\u6ce8\u89e3");
        p.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:dms=\"").append(clazzAnno.targetNameSpace()).append("\">");
        p.append("<soapenv:Header/>");
        p.append("<soapenv:Body>");
        p.append("<").append(clazzAnno.methodName());
        if (StringUtils.hasText((String)clazzAnno.methodNameSpace())) {
            p.append(" ").append(clazzAnno.methodNameSpace());
        }
        p.append(">");
        p.append("<MESSAGE>");
        String[] tags = clazzAnno.tags();
        LinkedList<String> tagStack = new LinkedList<String>();
        if (tags != null) {
            for (String tag : tags) {
                p.append("<").append(tag).append(">");
                tagStack.push("</" + tag + ">");
            }
        }
        SapUtil.generateXmlByClass(t, clazz, p, "");
        while (!tagStack.isEmpty()) {
            p.append((String)tagStack.pop());
        }
        p.append("</MESSAGE>");
        p.append("</").append(clazzAnno.methodName()).append(">");
        p.append("</soapenv:Body>");
        p.append("</soapenv:Envelope>");
        return p.toString();
    }

    public static <T> String convertParam(T t, Class<T> clazz, String targetNameSpace) {
        StringBuilder p = new StringBuilder();
        XmlRootProperty clazzAnno = clazz.getAnnotation(XmlRootProperty.class);
        Assert.notNull((Object)clazzAnno, (String)"\u7c7b\u4e0a\u7f3a\u5931\u3010XmlRootProperty\u3011\u6ce8\u89e3");
        p.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" ").append(targetNameSpace).append(">");
        p.append("<soapenv:Header/>");
        p.append("<soapenv:Body>");
        p.append("<").append(clazzAnno.methodName());
        if (StringUtils.hasText((String)clazzAnno.methodNameSpace())) {
            p.append(" ").append(clazzAnno.methodNameSpace());
        }
        p.append(">");
        p.append("<I_REQUEST>");
        p.append("<MESSAGE>");
        String[] tags = clazzAnno.tags();
        LinkedList<String> tagStack = new LinkedList<String>();
        if (tags != null) {
            for (String tag : tags) {
                p.append("<").append(tag).append(">");
                tagStack.push("</" + tag + ">");
            }
        }
        SapUtil.generateXmlByClass(t, clazz, p, "");
        while (!tagStack.isEmpty()) {
            p.append((String)tagStack.pop());
        }
        p.append("</MESSAGE>");
        p.append("</I_REQUEST>");
        p.append("</").append(clazzAnno.methodName()).append(">");
        p.append("</soapenv:Body>");
        p.append("</soapenv:Envelope>");
        return p.toString();
    }

    public static void mapToXML(Map<?, ?> map, StringBuilder sb) {
        Set<?> set = map.keySet();
        for (String key : set) {
            Object value = map.get(key);
            if (value instanceof Map) {
                sb.append("<").append(key).append(">\n");
                SapUtil.mapToXML((Map)value, sb);
                sb.append("</").append(key).append(">\n");
                continue;
            }
            if (value instanceof List) {
                List list = (List)map.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    sb.append("<").append(key).append(">\n");
                    Map hm = (Map)list.get(i);
                    SapUtil.mapToXML(hm, sb);
                    sb.append("</").append(key).append(">\n");
                }
                continue;
            }
            sb.append("<").append(key).append(">").append(value).append("</").append(key).append(">\n");
        }
    }

    public static <R> R setResponseData(Map<String, String> key2Data, Class<R> clazz) {
        R obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            log.info("\u5b9e\u4f8b\u5316\u5931\u8d25");
            return null;
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            SapFormField sapFormField = field.getAnnotation(SapFormField.class);
            if (null == sapFormField) continue;
            try {
                field.setAccessible(true);
                field.set(obj, key2Data.get(sapFormField.key()));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static <R> List<R> setResponseDataBatch(List<Map<String, String>> key2DataList, Class<R> clazz) {
        if (CollectionUtils.isEmpty(key2DataList)) {
            return Lists.newArrayList();
        }
        ArrayList reList = new ArrayList(key2DataList.size());
        key2DataList.forEach(key2Data -> reList.add(SapUtil.setResponseData(key2Data, clazz)));
        return reList;
    }

    private static void storeLog(String url, String p, String r) {
        p = "\u63a5\u53e3\u5730\u5740:" + url + "\n\u53c2\u6570:" + p;
    }

    public static String sendParamBody(String url, String param, String username, String password) {
        String p = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:cass=\"http://cofco.com/mm/cass\">\n   <soapenv:Header/>\n   <soapenv:Body>\n" + param + "   </soapenv:Body>\n</soapenv:Envelope>";
        long tid = Thread.currentThread().getId();
        log.info("tid:{},sap\u5165\u53c2url:{}", (Object)tid, (Object)url);
        log.info("tid:{},sap\u5165\u53c2param:{}", (Object)tid, (Object)p);
        HttpHeaders headers = new HttpHeaders();
        SapUtil.setToken(headers, username, password);
        HttpEntity httpEntity = new HttpEntity((Object)p, (MultiValueMap)headers);
        ResponseEntity exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        log.info("tid:{},sap\u54cd\u5e94result:{}", (Object)tid, (Object)exchange);
        SapUtil.storeLog(url, p, String.valueOf(exchange.getBody()));
        String body = (String)exchange.getBody();
        log.info("tid:{},body:{}", (Object)tid, (Object)exchange);
        Assert.hasText((String)body, (String)"\u7f3a\u5931\u8fd4\u56de\u6570\u636e");
        return body;
    }

    public static <T> String cassConvertParam(List<T> dataList, Class<T> clazz) {
        StringBuilder p = new StringBuilder();
        XmlRootProperty clazzAnno = clazz.getAnnotation(XmlRootProperty.class);
        Assert.notNull((Object)clazzAnno, (String)"\u7c7b\u4e0a\u7f3a\u5931\u3010XmlRootProperty\u3011\u6ce8\u89e3");
        p.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tem=\"").append(clazzAnno.targetNameSpace()).append("\">");
        p.append("<soapenv:Header/>");
        p.append("<soapenv:Body>");
        p.append("<").append(clazzAnno.methodName());
        if (StringUtils.hasText((String)clazzAnno.methodNameSpace())) {
            p.append(" ").append(clazzAnno.methodNameSpace());
        }
        p.append(">");
        p.append("<tem:ReturnInfolist>");
        String[] tags = clazzAnno.tags();
        LinkedList<String> tagStack = new LinkedList<String>();
        if (tags != null) {
            for (String tag : tags) {
                p.append("<").append(tag).append(">");
                tagStack.push("</" + (String)tag + ">");
            }
        }
        for (Object t : dataList) {
            p.append("<tem:ReturnInfo>");
            SapUtil.generateXmlByClass(t, clazz, p, "");
            p.append("</tem:ReturnInfo>");
        }
        while (!tagStack.isEmpty()) {
            p.append((String)tagStack.pop());
        }
        p.append("</tem:ReturnInfolist>");
        p.append("</").append(clazzAnno.methodName()).append(">");
        p.append("</soapenv:Body>");
        p.append("</soapenv:Envelope>");
        return p.toString();
    }

    public static <T, R> R sendNoAuth(String url, T param) {
        long tid = Thread.currentThread().getId();
        log.info("tid:{},sap\u5165\u53c2url:{}", (Object)tid, (Object)url);
        log.info("tid:{},sap\u5165\u53c2param:{}", (Object)tid, param);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-type", "text/xml; charset=utf-8");
        headers.set("Accept", "text/xml; charset=utf-8");
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity exchange = null;
        try {
            exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<R>(){}, new Object[0]);
        }
        catch (RestClientException e) {
            SapUtil.storeLog(url, String.valueOf(param), String.valueOf(e.getCause()));
            throw new RuntimeException(e);
        }
        log.info("tid:{},sap\u54cd\u5e94result:{}", (Object)tid, (Object)exchange);
        SapUtil.storeLog(url, String.valueOf(param), String.valueOf(exchange.getBody()));
        Object body = exchange.getBody();
        log.info("tid:{},body:{}", (Object)tid, (Object)exchange);
        Assert.notNull((Object)body, (String)"\u7f3a\u5931\u8fd4\u56de\u6570\u636e");
        return (R)body;
    }

    public static <T> String convertCustomerParam(T t, Class<T> clazz) {
        StringBuilder p = new StringBuilder();
        XmlRootProperty clazzAnno = clazz.getAnnotation(XmlRootProperty.class);
        Assert.notNull((Object)clazzAnno, (String)"\u7c7b\u4e0a\u7f3a\u5931\u3010XmlRootProperty\u3011\u6ce8\u89e3");
        p.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:dms=\"").append(clazzAnno.targetNameSpace()).append("\">");
        p.append("<soapenv:Header/>");
        p.append("<soapenv:Body>");
        p.append("<").append(clazzAnno.methodName());
        if (StringUtils.hasText((String)clazzAnno.methodNameSpace())) {
            p.append(" ").append(clazzAnno.methodNameSpace());
        }
        p.append(">");
        p.append("<MESSAGE>");
        String[] tags = clazzAnno.tags();
        LinkedList<String> tagStack = new LinkedList<String>();
        if (tags != null) {
            for (String tag : tags) {
                p.append("<").append(tag).append(">");
                tagStack.push("</" + tag + ">");
            }
        }
        StringBuilder other = new StringBuilder();
        SapUtil.generateXmlOtherByClass(t, clazz, p, other);
        while (!tagStack.isEmpty()) {
            p.append((String)tagStack.pop());
        }
        p.append("</MESSAGE>");
        p.append((CharSequence)other);
        p.append("</").append(clazzAnno.methodName()).append(">");
        p.append("</soapenv:Body>");
        p.append("</soapenv:Envelope>");
        return p.toString();
    }

    public static <T> void generateXmlOtherByClass(T t, Class<T> clazz, StringBuilder p, StringBuilder other) {
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, List<Pair<String, Object>>> dataGroupByPrefix = new HashMap<String, List<Pair<String, Object>>>();
        HashMap<String, List<Pair<String, Object>>> otherDataGroupByPrefix = new HashMap<String, List<Pair<String, Object>>>();
        for (Field field : fields) {
            XmlFieldProperty anno = field.getAnnotation(XmlFieldProperty.class);
            if (anno == null) continue;
            String name = anno.name();
            Assert.hasText((String)name, (String)(field.getName() + "\u7f3a\u5931\u5c5e\u6027\u540d\u79f0"));
            try {
                field.setAccessible(true);
                Object data = field.get(t);
                if (!anno.other()) {
                    SapUtil.appendField(p, dataGroupByPrefix, anno, name, data);
                    continue;
                }
                SapUtil.appendField(other, otherDataGroupByPrefix, anno, name, data);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
                throw new RuntimeException(e);
            }
        }
        SapUtil.appendMap(p, dataGroupByPrefix);
        SapUtil.appendMap(other, otherDataGroupByPrefix);
    }

    private static void appendMap(StringBuilder p, Map<String, List<Pair<String, Object>>> dataGroupByPrefix) {
        if (!CollectionUtils.isEmpty(dataGroupByPrefix)) {
            dataGroupByPrefix.forEach((prefix, dataList) -> {
                p.append("<").append((String)prefix).append(">");
                HashSet repeatSet = new HashSet();
                dataList.forEach(e -> {
                    String first = (String)e.getFirst();
                    if (repeatSet.add(first)) {
                        p.append("<").append(first).append(">");
                        p.append(e.getSecond());
                        p.append("</" + first + ">");
                    }
                });
                p.append("</" + prefix + ">");
            });
        }
    }

    private static boolean appendField(StringBuilder other, Map<String, List<Pair<String, Object>>> otherDataGroupByPrefix, XmlFieldProperty anno, String name, Object data) {
        if (null != data) {
            if (anno.list()) {
                SapUtil.generateXmlBatchByClass((List)data, anno.itemClass(), other, anno.name());
                return true;
            }
            String[] fieldArr = name.split("\\.");
            Validate.isTrue((fieldArr.length <= 2 ? 1 : 0) != 0, (String)"\u76ee\u524d\u4ec5\u652f\u63012\u5c42\u524d\u7f00", (Object[])new Object[0]);
            if (fieldArr.length == 1) {
                other.append("<").append(fieldArr[0]).append(">");
                other.append(data);
                other.append("</" + fieldArr[0] + ">");
            } else {
                List key2Data = otherDataGroupByPrefix.getOrDefault(fieldArr[0], new ArrayList());
                key2Data.add(Pair.of((Object)fieldArr[1], (Object)data));
                otherDataGroupByPrefix.put(fieldArr[0], key2Data);
            }
        }
        return false;
    }

    static {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.TEXT_HTML));
        restTemplate.getMessageConverters().add(mappingJackson2HttpMessageConverter);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    private static class NodeData {
        private String singleData;
        private LinkedList<Map<String, String>> multiData;

        public NodeData(String singleData) {
            this.singleData = singleData;
        }

        public NodeData(LinkedList<Map<String, String>> multiData) {
            this.multiData = multiData;
        }

        public String getSingleData() {
            return this.singleData;
        }

        public void setSingleData(String singleData) {
            this.singleData = singleData;
        }

        public LinkedList<Map<String, String>> getMultiData() {
            return this.multiData;
        }

        public void setMultiData(LinkedList<Map<String, String>> multiData) {
            this.multiData = multiData;
        }
    }
}

