package com.biz.crm.business.common.base.util;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.model.Result;
import io.jsonwebtoken.lang.Assert;
import org.apache.commons.lang3.Validate;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @Description
 * @Author lifei
 * @Date 2025/1/14 16:37
 **/
public class ExternalSystemUtil {

    /**
     * 获取MD5
     * @param plainText
     * @return
     */
    public static String getMD5Str(String plainText) {
        //定义一个字节数组
        byte[] secretBytes = null;
        try {
            // 生成一个MD5加密计算摘要
            MessageDigest md = MessageDigest.getInstance("MD5");
            //对字符串进行加密
            md.update(plainText.getBytes());
            //获得加密后的数据
            secretBytes = md.digest();
        } catch (NoSuchAlgorithmException e) {
            //throw new RuntimeException("没有md5这个算法！");
            throw new RuntimeException("没有MD5");
        }
        //将加密后的数据转换为16进制数字
        String md5code = new BigInteger(1, secretBytes).toString(16);
        // 如果生成数字未满32位，需要前面补0
        // 不能把变量放到循环条件，值改变之后会导致条件变化。如果生成30位 只能生成31位md5
        int tempIndex = 32 - md5code.length();
        for (int i = 0; i < tempIndex; i++) {
            md5code = "0" + md5code;
        }
        return md5code.toLowerCase();
    }


    /**
     * 校验结果
     * @param result
     * @return
     */
    public static String checkResult(Result<String> result) {
        Assert.isTrue(result.isSuccess(), String.format("拉取北森主数据信息失败：%s",result.getMessage()));
        Assert.hasLength(result.getResult(), "拉取北森主数据为空:" + result.getMessage());
        JSONObject jsonObject = JSONObject.parseObject(result.getResult());
        Validate.isTrue(jsonObject.containsKey("code"), String.format("拉取北森主数据失败"));
        Validate.isTrue(jsonObject.getInteger("code").equals(CommonConstant.SC_OK_200), "拉取北森主数据失败:%s",jsonObject.get("message"));
        return jsonObject.toJSONString();
    }
}
