package com.biz.crm.business.common.base.util;

import jodd.bean.BeanTool;
import jodd.bean.BeanUtil;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * bean工具类.
 * @author grover
 * @version v1.0
 */
public class MyBeanUtils extends org.apache.commons.beanutils.BeanUtils {

    private static void convert(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {

        // Validate existence of the specified beans
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }

        // Copy the properties, converting as necessary
        if (orig instanceof DynaBean) {
            DynaProperty origDescriptors[] = ((DynaBean) orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; i++) {
                String name = origDescriptors[i].getName();
                if (PropertyUtils.isWriteable(dest, name)) {
                    Object value = ((DynaBean) orig).get(name);
                    try {
                        copyProperty(dest, name, value);
                    } catch (Exception e) {
                        ; // Should not happen
                    }

                }
            }
        } else if (orig instanceof Map) {
            Iterator names = ((Map) orig).keySet().iterator();
            while (names.hasNext()) {
                String name = (String) names.next();
                if (PropertyUtils.isWriteable(dest, name)) {
                    Object value = ((Map) orig).get(name);
                    try {
                        copyProperty(dest, name, value);
                    } catch (Exception e) {
                        ; // Should not happen
                    }

                }
            }
        } else
            /* if (orig is a standard JavaBean) */
        {
            PropertyDescriptor origDescriptors[] = PropertyUtils.getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; i++) {
                String name = origDescriptors[i].getName();
                // String type = origDescriptors[i].getPropertyType().toString();
                if ("class".equals(name)) {
                    continue; // No point in trying to set an object's class
                }
                if (PropertyUtils.isReadable(orig, name) && PropertyUtils.isWriteable(dest, name)) {
                    try {
                        Object value = PropertyUtils.getSimpleProperty(orig, name);
                        copyProperty(dest, name, value);
                    } catch (java.lang.IllegalArgumentException ie) {
                        ; // Should not happen
                    } catch (Exception e) {
                        ; // Should not happen
                    }

                }
            }
        }

    }

    /**
     * 对象拷贝 数据对象空值不拷贝到目标对象
     *
     * @throws NoSuchMethodException
     *             copy
     */
    public static void copyBeanNotNull2Bean(Object databean, Object tobean) throws Exception {
        PropertyDescriptor origDescriptors[] = PropertyUtils.getPropertyDescriptors(databean);
        for (int i = 0; i < origDescriptors.length; i++) {
            String name = origDescriptors[i].getName();
            // String type = origDescriptors[i].getPropertyType().toString();
            if ("class".equals(name)) {
                continue; // No point in trying to set an object's class
            }
            if (PropertyUtils.isReadable(databean, name) && PropertyUtils.isWriteable(tobean, name)) {
                try {
                    Object value = PropertyUtils.getSimpleProperty(databean, name);
                    if (StringUtil.isNotEmpty(value)) {
                        if(!isJavaClass(value.getClass())){  //如果属性为class 那么 获取处
                            // 属性对应的 类然后复制两个类 然后赋值给 目标对象
                            Field f= tobean.getClass().getDeclaredField(name);
                            Class ss= f.getType();
                            if (ss.getName().equals("java.util.List")){
                                copyProperty(tobean, name, value);
                            }else{
                                Object t= null;
                                try {
                                    t = ss.newInstance();
                                } catch (InstantiationException e) {
                                    e.printStackTrace();
                                } catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                copyBeanNotNull2Bean(value,t);//把复杂对象给复制过去
                                //再复制对象到对应的 属性里去
                                f.setAccessible(true); // 设置属性可以直接的进行访问
                                f.set(tobean, t);
                            }
                        }else {
                            copyProperty(tobean, name, value);
                        }

                    }
                } catch (java.lang.IllegalArgumentException ie) {
                    ; // Should not happen
                } catch (Exception e) {
                    ; // Should not happen
                }

            }
        }
    }

    /**
     * 判断一个类是JAVA类型还是用户定义类型
     * @param clz
     * @return
     */
    public static boolean isJavaClass(Class<?> clz) {
        return clz != null && clz.getClassLoader() == null;
    }

    /**
     * 把orig和dest相同属性的value复制到dest中
     *
     * @param dest
     * @param orig
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static void copyBean2Bean(Object dest, Object orig) throws Exception {
        convert(dest, orig);
    }

    public static void copyBean2Map(Map map, Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors(bean);
        for (int i = 0; i < pds.length; i++) {
            PropertyDescriptor pd = pds[i];
            String propname = pd.getName();
            try {
                Object propvalue = PropertyUtils.getSimpleProperty(bean, propname);
                map.put(propname, propvalue);
            } catch (IllegalAccessException e) {
                // e.printStackTrace();
            } catch (InvocationTargetException e) {
                // e.printStackTrace();
            } catch (NoSuchMethodException e) {
                // e.printStackTrace();
            }
        }
    }

    /**
     * 将Map内的key与Bean中属性相同的内容复制到BEAN中
     *
     * @param bean
     *            Object
     * @param properties
     *            Map
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static void copyMap2Bean(Object bean, Map properties) throws IllegalAccessException,
            InvocationTargetException {
        // Do nothing unless both arguments have been specified
        if ((bean == null) || (properties == null)) {
            return;
        }
        // Loop through the property name/value pairs to be set
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String) names.next();
            // Identify the property name and value(s) to be assigned
            if (name == null) {
                continue;
            }
            Object value = properties.get(name);
            try {
                Class clazz = PropertyUtils.getPropertyType(bean, name);
                if (null == clazz) {
                    continue;
                }
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.sql.Timestamp")) {
                    if (value == null || value.equals("")) {
                        continue;
                    }
                }
                if (className.equalsIgnoreCase("java.math.BigDecimal")) {
                    if (value == null || value.equals("")) {
                        continue;
                    }
                }

                setProperty(bean, name, value);
            } catch (NoSuchMethodException e) {
                continue;
            }
        }
    }

    /**
     * 自动转Map key值大写 将Map内的key与Bean中属性相同的内容复制到BEAN中
     *
     * @param bean
     *            Object
     * @param properties
     *            Map
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static void copyMap2BeanReflect(Object bean, Map properties) throws Exception {
        // Do nothing unless both arguments have been specified
        if ((bean == null) || (properties == null)) {
            return;
        }
        // Loop through the property name/value pairs to be set
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {

            ReflectHelper reflectHelper = new ReflectHelper(bean);

            String name = (String) names.next();
            // Identify the property name and value(s) to be assigned
            if (name == null) {
                continue;
            }

            try {
                Object value = properties.get(name);
                reflectHelper.setMethodValue(name, value);
            } catch (Exception e) {
                continue;
            }
        }
    }

    /**
     * 自动转Map key值大写 将Map内的key与Bean中属性相同的内容复制到BEAN中
     *
     * @param bean
     *            Object
     * @param properties
     *            Map
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static void copyMap2Bean_Nobig(Object bean, Map properties) throws IllegalAccessException,
            InvocationTargetException {
        // Do nothing unless both arguments have been specified
        if ((bean == null) || (properties == null)) {
            return;
        }
        // Loop through the property name/value pairs to be set
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String) names.next();
            // Identify the property name and value(s) to be assigned
            if (name == null) {
                continue;
            }
            Object value = properties.get(name);
            // 命名应该大小写应该敏感(否则取不到对象的属性)
            // name = name.toLowerCase();
            try {
                if (value == null) { // 不光Date类型，好多类型在null时会出错
                    continue; // 如果为null不用设 (对象如果有特殊初始值也可以保留？)
                }
                Class clazz = PropertyUtils.getPropertyType(bean, name);
                if (null == clazz) { // 在bean中这个属性不存在
                    continue;
                }
                String className = clazz.getName();
                // 临时对策（如果不处理默认的类型转换时会出错）
                if (className.equalsIgnoreCase("java.util.Date")) {
                    value = new java.util.Date(((java.sql.Timestamp) value).getTime());// wait to do：貌似有时区问题, 待进一步确认
                }
                // if (className.equalsIgnoreCase("java.sql.Timestamp")) {
                // if (value == null || value.equals("")) {
                // continue;
                // }
                // }
                setProperty(bean, name, value);
            } catch (NoSuchMethodException e) {
                continue;
            }
        }
    }

    /**
     * Map内的key与Bean中属性相同的内容复制到BEAN中 对于存在空值的取默认值
     *
     * @param bean
     *            Object
     * @param properties
     *            Map
     * @param defaultValue
     *            String
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    public static void copyMap2Bean(Object bean, Map properties, String defaultValue) throws IllegalAccessException,
            InvocationTargetException {
        // Do nothing unless both arguments have been specified
        if ((bean == null) || (properties == null)) {
            return;
        }
        // Loop through the property name/value pairs to be set
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String) names.next();
            // Identify the property name and value(s) to be assigned
            if (name == null) {
                continue;
            }
            Object value = properties.get(name);
            try {
                Class clazz = PropertyUtils.getPropertyType(bean, name);
                if (null == clazz) {
                    continue;
                }
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.sql.Timestamp")) {
                    if (value == null || value.equals("")) {
                        continue;
                    }
                }
                if (className.equalsIgnoreCase("java.lang.String")) {
                    if (value == null) {
                        value = defaultValue;
                    }
                }
                setProperty(bean, name, value);
            } catch (NoSuchMethodException e) {
                continue;
            }
        }
    }

    public MyBeanUtils() {
        super();
    }


    /**
     * 应用所有与目标对象的属性相匹配的源对象中的非null属性值到目标对象中。
     *
     * @param srcBean
     * @param dstBean
     */
    public static void apply(Object srcBean, Object dstBean) {
        copy(srcBean, dstBean, null, (Collection<String>) null, null, false);
    }
    /**
     * 拷贝所有属性相同的对象值 可指定不拷贝的属性。
     *
     * @param srcBean
     * @param dstBean
     * @param ignoredProps
     */
    public static void sepecialCopy(Object srcBean, Object dstBean, Collection<String> ignoredProps) {
        copy(srcBean, dstBean, null, ignoredProps, null, true);
    }
    /**
     * 提交基本的Bean操作能力。
     *
     * 所有的Bean操作的规范如下：
     *      按目标Bean中的所有属性(如果指定了待复制属性列表，则仅限于待复制属性列表)，
     *      如果该属性不在被忽略属性中，且有源Bean中的对应属性， 则以源Bean中的对应属性设置目标Bean中的属性。
     * 源与目标间的属性对应方式为：
     *      如果存在映射表， 以则目标对象中的属性为key从映射表中查到的字符串为源对象中的属性名称。
     *      如果不存在映射表，或映射表中不包含指定的属性， 则源对象中的属性名称与目标对象的属性名称相同。
     *
     * @param srcBean
     * @param dstBean
     * @param revertMap 属性转换表， 为空则不转换。 属性转换表中不存在的项目也不做转换。
     * @param ignoredProps 被忽略的属性列表
     * @param props 希望被复制的属性
     * @param copyNull 是否复制空值。
     */
    private static void copy(Object srcBean, Object dstBean, Map<String, String> revertMap,
                             Collection<String> ignoredProps, Collection<String> props, boolean copyNull) {
        String[] properties = BeanTool.resolveProperties(dstBean, true);
        String srcPropName;
        Object value;

        for (String property : properties) {
            // 过滤掉不在指定属性列表中的属性
            if (props != null && !props.contains(property)) {
                continue;
            }
            // 过滤掉在忽略属性列表中的属性
            if (ignoredProps != null && ignoredProps.contains(property)) {
                continue;
            }
            if (revertMap != null) {
                srcPropName = revertMap.get(property);
                if (srcPropName == null) {
                    srcPropName = property;
                }
            } else {
                srcPropName = property;
            }
            // 使用Silently版本， 这样将允许不存在的目标字段存在而继续工作，但这样也将掩盖一些问题。
            value = BeanUtil.silent.getProperty(srcBean, srcPropName);
            if (value == null && !copyNull) {
                continue;
            }
            BeanUtil.silent.setProperty(dstBean, property, value);
        }
    }

    public static <T> List<T> copyList(List source, Class<T> clazz) {
        List<T> target = new ArrayList<>();
        if (!CollectionUtils.isEmpty(source)){
            for (Object c: source) {
                T obj = copy(c, clazz);
                target.add(obj);
            }
        }
        return target;
    }

    public static <T> T copy(Object source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        T obj = null;
        try {
            obj = clazz.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BeanUtils.copyProperties(source, obj);
        return obj;
    }
}
