package com.biz.crm.business.common.base.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author xuduan
 * @version v1.0
 * @Title: 字符串工具类
 * @Description: 字符串工具类
 * @date 2018/10/25
 */
@Slf4j
public class SqlUtil {

    /**
     * 集合转换为字符串
     *
     * @param objList
     * @param proName
     * @param type    是否带单引号
     * @return
     */
    public static String listToReplaceStr(List<?> objList, String proName, boolean type) {
        List<String> strList = new ArrayList<String>();
        for (Object object : objList) {
            String proStr = null;
            try {
                if (PropertyUtils.getProperty(object, proName) != null) {
                    proStr = String.valueOf(PropertyUtils.getProperty(object, proName));
                }
            } catch (InvocationTargetException | NoSuchMethodException | IllegalAccessException e) {
                log.error(e.getMessage(), e);
            }
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty(proStr)) {
                if (type) {
                    sb.append("'");
                    sb.append(proStr);
                    sb.append("'");
                } else {
                    sb.append(proStr);
                }
            }
            if (StringUtils.isNotEmpty(sb.toString())) {
                strList.add(sb.toString());
            }
        }
        return StringUtils.join(strList, ",");
    }

    public static String arrayToInStr(String str, String splitStr) {
        String[] arry = str.split(splitStr);
        StringBuilder stringBuffer = new StringBuilder("");
        if (arry.length > 0) {
            for (int i = 0; i < arry.length; i++) {
                if (StringUtils.isNotEmpty(arry[i])) {
                    stringBuffer.append("'");
                    stringBuffer.append(arry[i]);
                    stringBuffer.append("'");
                    if (i != arry.length - 1) {
                        stringBuffer.append(",");
                    }
                }
            }
            return stringBuffer.toString();
        } else {
            return null;
        }
    }

    public static String bracketsSetToReplaceStr(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return " (" + setToReplaceStr(set, true) + ") ";
    }

    public static String setToReplaceStr(Set<?> set, boolean type) {
        List<String> strList = new ArrayList<String>();
        for (Object object : set) {
            String proStr = null;
            StringBuffer sb = new StringBuffer();
            if (type) {
                sb.append("'");
                sb.append(object);
                sb.append("'");
            } else {
                sb.append(proStr);
            }
            strList.add(sb.toString());
        }
        return StringUtils.join(strList, ",");
    }

    /**
     * 转换sqlin条数
     *
     * @param arr
     * @param inparam in 字段
     * @param type    是否加单引号
     * @return
     */
    public static String setSqlIn(String[] arr, String inparam, boolean type, String othersql) {
        if (arr != null && arr.length > 0) {
            StringBuffer sqlin_ = new StringBuffer();
            StringBuffer sqlin = new StringBuffer();
            StringBuffer in = new StringBuffer();
            int sn = arr.length / 900;//计算有多少个900数据
            int s = arr.length % 900;//计算有多少个900数据后的余数
            if (s > 0) {//如果有余数那么循环数加1
                sn = sn + 1;
            }
            for (int i = 0; i < sn; i++) {
                in = new StringBuffer();
                int en = (i + 1) * 900;
                if (s > 0 && i == (sn - 1)) {//如果有余数那么 结束位置为之前的位置加上余数
                    en = i * 900 + s;
                }
                for (int j = i * 900; j < en; j++) {
                    if (StringUtils.isNotBlank(arr[j])) {
                        if (type) {
                            in.append("'");
                            in.append(arr[j]);
                            in.append("'");
                        } else {
                            in.append(arr[j]);
                        }
                        if (j != en - 1) {
                            in.append(",");
                        }
                    }
                }
                if (i != 0) {
                    sqlin.append(" or " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                } else {
                    sqlin.append(" " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                }
            }
            if (StringUtils.isNotEmpty(othersql)) {
                sqlin_.append(othersql);
            }
            sqlin_.append(" (");
            sqlin_.append(sqlin.toString());
            sqlin_.append(")");
            return sqlin_.toString();
        }
        return null;
    }

    public static String setSqlIn(List<String> list, String inparam, boolean type, String othersql) {
        String[] arr = list.toArray(new String[list.size()]);
        if (arr != null && arr.length > 0) {
            StringBuffer sqlin_ = new StringBuffer();
            StringBuffer sqlin = new StringBuffer();
            StringBuffer in = new StringBuffer();
            int sn = arr.length / 900;//计算有多少个900数据
            int s = arr.length % 900;//计算有多少个900数据后的余数
            if (s > 0) {//如果有余数那么循环数加1
                sn = sn + 1;
            }
            for (int i = 0; i < sn; i++) {
                in = new StringBuffer();
                int en = (i + 1) * 900;
                if (s > 0 && i == (sn - 1)) {//如果有余数那么 结束位置为之前的位置加上余数
                    en = i * 900 + s;
                }
                for (int j = i * 900; j < en; j++) {
                    if (StringUtils.isNotBlank(arr[j])) {
                        if (type) {
                            in.append("'");
                            in.append(arr[j]);
                            in.append("'");
                        } else {
                            in.append(arr[j]);
                        }
                        if (j != en - 1) {
                            in.append(",");
                        }
                    }
                }
                if (i != 0) {
                    sqlin.append(" or " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                } else {
                    sqlin.append(" " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                }
            }
            if (StringUtils.isNotEmpty(othersql)) {
                sqlin_.append(othersql);
            }
            sqlin_.append(" (");
            sqlin_.append(sqlin.toString());
            sqlin_.append(")");
            return sqlin_.toString();
        }
        return null;
    }

    public static String setSqlIn500(List<String> arr, String inparam, boolean type) {
        if (CollectionUtils.isNotEmpty(arr)) {
            StringBuffer sqlin_ = new StringBuffer();
            StringBuffer sqlin = new StringBuffer();
            StringBuffer in = new StringBuffer();
            int sn = arr.size() / 900;//计算有多少个900数据
            int s = arr.size() % 900;//计算有多少个900数据后的余数
            if (s > 0) {//如果有余数那么循环数加1
                sn = sn + 1;
            }
            for (int i = 0; i < sn; i++) {
                in = new StringBuffer();
                int en = (i + 1) * 900;
                if (s > 0 && i == (sn - 1)) {//如果有余数那么 结束位置为之前的位置加上余数
                    en = i * 900 + s;
                }
                for (int j = i * 900; j < en; j++) {
                    if (StringUtils.isNotBlank(arr.get(j))) {
                        if (type) {
                            in.append("'");
                            in.append(arr.get(j));
                            in.append("'");
                        } else {
                            in.append(arr.get(j));
                        }
                        if (j != en - 1) {
                            in.append(",");
                        }
                    }
                }
                if (i != 0) {
                    sqlin.append(" or " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                } else {
                    sqlin.append(" " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                }
            }
            sqlin_.append(" (");
            sqlin_.append(sqlin.toString());
            sqlin_.append(")");
            return sqlin_.toString();
        }
        return null;
    }

    /**
     * 转换sqlin 条数 适合1000以内in
     *
     * @param arr
     * @param inparam in 字段
     * @param type    是否加单引号
     * @return
     */
    public static String setlessSqlIn(String[] arr, String inparam, boolean type) {
        if (arr != null && arr.length > 0) {
            StringBuffer in = new StringBuffer();
            int sn = arr.length;
            for (int i = 0; i < sn; i++) {
                in = new StringBuffer();
                if (StringUtils.isNotBlank(arr[i])) {
                    if (type) {
                        in.append("'");
                        in.append(arr[i]);
                        in.append("'");
                    } else {
                        in.append(arr[i]);
                    }
                    if (i != sn - 1) {
                        in.append(",");
                    }
                }
                if (StringUtils.isNotBlank(inparam)) {

                    in.append(inparam);
                    in.append(" in (");
                    in.append(in.toString());
                    in.append(")");
                }
            }
            return in.toString();
        }
        return null;
    }

    public static HashSet<String> listToReplaceSet(List<?> objList, String proName) {
        HashSet<String> targ = new HashSet<String>();
        for (Object object : objList) {
            String proStr = null;
            try {
                proStr = String.valueOf(PropertyUtils.getProperty(object, proName));
            } catch (InvocationTargetException | IllegalAccessException | NoSuchMethodException e) {
                log.error(e.getMessage(), e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(proStr);
            targ.add(sb.toString());
        }
        return targ;
    }

    /**
     * 转换集合为数组
     *
     * @param objList
     * @param proName
     * @return
     */
    public static String[] listToReplaceArr(List<?> objList, String proName) {
        String[] targ = new String[objList.size()];
        for (int i = 0, len = objList.size(); i < len; i++) {
            String proStr = null;
            try {
                proStr = String.valueOf(PropertyUtils.getProperty(objList.get(i), proName));
            } catch (InvocationTargetException | NoSuchMethodException | IllegalAccessException e) {
                log.error(e.getMessage(), e);
            }
            targ[i] = proStr;
        }
        return targ;
    }

    public static String setSqlIn(Set<String> list, String inparam, boolean type, String othersql) {
        int num = 900;
        String[] arr = list.toArray(new String[list.size()]);
        if (arr != null && arr.length > 0) {
            StringBuffer sqlin_ = new StringBuffer();
            StringBuffer sqlin = new StringBuffer();
            StringBuffer in = new StringBuffer();
            int sn = arr.length / num;//计算有多少个900数据
            int s = arr.length % num;//计算有多少个900数据后的余数
            if (s > 0) {//如果有余数那么循环数加1
                sn = sn + 1;
            }
            for (int i = 0; i < sn; i++) {
                in = new StringBuffer();
                int en = (i + 1) * num;
                if (s > 0 && i == (sn - 1)) {//如果有余数那么 结束位置为之前的位置加上余数
                    en = i * num + s;
                }
                for (int j = i * num; j < en; j++) {
                    if (StringUtils.isNotBlank(arr[j])) {
                        if (type) {
                            in.append("'");
                            in.append(arr[j]);
                            in.append("'");
                        } else {
                            in.append(arr[j]);
                        }
                        if (j != en - 1) {
                            in.append(",");
                        }
                    }
                }
                if (i != 0) {
                    sqlin.append(" or " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                } else {
                    sqlin.append(" " + inparam + " in (" + in.toString() + ")");//+=" and tb.dms_code in ("+in+")";
                }
            }
            sqlin_.append(sqlin.toString());
            if (StringUtils.isNotEmpty(othersql)) {
                sqlin_.append(othersql);
            }
            sqlin_.append(")");
            return sqlin_.toString();
        }
        return null;
    }
}
