/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.biz.crm.business.common.base.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DateStringDealUtil {
    private static final Logger log = LoggerFactory.getLogger(DateStringDealUtil.class);
    protected static final ThreadLocal<ConcurrentHashMap<String, SimpleDateFormat>> DATE_FORMAT_MAP_THREAD_LOCAL = new ThreadLocal();

    public static void setStringIfNotNull(Date obj, String pattern, Consumer<String> setMethod) {
        if (null != obj) {
            String value = DateStringDealUtil.getDateFormat(pattern).format(obj);
            setMethod.accept(value);
        }
    }

    public static <T> void validateDateStrAndSet(String str, String desc, String pattern, Consumer<Date> setMethod) {
        DateStringDealUtil.validateDateStrAndSet(str, desc, true, pattern, setMethod);
    }

    public static void validateDateStrAndSet(String str, String desc, boolean required, String pattern, Consumer<Date> setMethod) {
        String errorMsg = DateStringDealUtil.validateDateStrAndSetErrorMsg(str, desc, required, pattern, setMethod);
        Assert.isTrue((boolean)StringUtils.isEmpty((CharSequence)errorMsg), (String)errorMsg);
    }

    public static String validateDateStrAndSetErrorMsg(String str, String desc, String pattern, Consumer<Date> setMethod) {
        return DateStringDealUtil.validateDateStrAndSetErrorMsg(str, desc, true, pattern, setMethod);
    }

    public static String validateDateStrAndSetErrorMsg(String str, String desc, boolean required, String pattern, Consumer<Date> setMethod) {
        if (StringUtils.isBlank((CharSequence)str)) {
            if (required) {
                return desc + "\u4e0d\u80fd\u4e3a\u7a7a";
            }
            return "";
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return desc + "\u7684\u65f6\u95f4\u683c\u5f0f[pattern]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Date value = DateStringDealUtil.getDateFormat(pattern).parse(str);
            if (!str.equals(DateUtil.format(value, pattern))) {
                return desc + "\u7684\u65f6\u95f4\u4e0d\u5408\u6cd5";
            }
            setMethod.accept(value);
            return "";
        }
        catch (ParseException e) {
            return desc + "[" + str + "]\u683c\u5f0f\u6709\u8bef";
        }
    }

    public static SimpleDateFormat getDateFormat(String pattern) {
        ConcurrentHashMap<String, SimpleDateFormat> dateFormatMap = DATE_FORMAT_MAP_THREAD_LOCAL.get();
        if (dateFormatMap == null) {
            dateFormatMap = new ConcurrentHashMap(16);
        } else if (dateFormatMap.containsKey(pattern)) {
            return dateFormatMap.get(pattern);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormatMap.put(pattern, dateFormat);
        DATE_FORMAT_MAP_THREAD_LOCAL.set(dateFormatMap);
        return dateFormat;
    }
}

