/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import com.biz.crm.common.ie.local.repository.ImportTemplateDetailRepository;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.sdk.enums.ExcelFileTypeEnum;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy;
import com.biz.crm.common.ie.sdk.vo.ExcelFileVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForImport;
import com.biz.crm.common.ie.sdk.vo.ImportExcelLocalFile;
import com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5bfc\u5165\u4efb\u52a1: ImportTask: \u5bfc\u5165\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/v1/importTask/importTask"})
public class ImportTaskDevelopmentController {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskDevelopmentController.class);
    @Autowired(required=false)
    private ImportTaskService importTaskService;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private List<ImportProcess> importProcesses;
    @Autowired(required=false)
    private ImportTemplateDetailRepository importTemplateDetailRepository;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private CrmExcelProcessStrategy crmExcelProcessStrategy;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Value(value="${spring.application.name:}")
    private String subsystem;

    @ApiOperation(value="\u6839\u636e\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u91cd\u65b0\u6267\u884c\u5bfc\u5165\u4efb\u52a1,\u5f00\u53d1\u4e13\u7528,\u7528\u4e8e\u5f00\u53d1\u672c\u5730\u8c03\u8bd5")
    @GetMapping(value={"/developmentDebugSpecialUse"})
    public Result<ImportTask> developmentDebugSpecialUse(@RequestParam(value="taskCode") String taskCode) {
        try {
            ImportTask task = this.importTaskService.findDetailByTaskCode(taskCode);
            IeExecutorVoForImport vo = new IeExecutorVoForImport();
            vo.setTaskCode(taskCode);
            vo.setApplicationName(task.getApplicationName());
            this.process((IeExecutorVo)vo, task);
            return Result.ok((Object)task);
        }
        catch (Exception var3) {
            log.error(var3.getMessage(), (Throwable)var3);
            return Result.error((String)var3.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(IeExecutorVo vo, ImportTask task) {
        OrdinaryFileVo templateFileVo;
        StopWatch sw = new StopWatch(CharSequenceUtil.format((CharSequence)"\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}", (Object[])new Object[]{vo.getTaskCode()}));
        sw.start("1\u3001\u4efb\u52a1\u9884\u5904\u7406");
        ImportTemplateDetail templateDetail = this.importTemplateDetailRepository.findDetailByTemplateCode(task.getTemplateCode());
        Validate.notNull((Object)templateDetail, (String)"\u672a\u914d\u7f6e\u5bfc\u5165\u7684\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        String templateFileCode = templateDetail.getFileCode();
        Validate.notEmpty((CharSequence)templateFileCode, (String)"\u672a\u914d\u7f6e\u5bfc\u5165\u7684\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        sw.stop();
        ImportProcess process = this.findImportProcess(task.getTemplateCode());
        CrmExcelImport crmExcelImport = process.findCrmExcelVoClass().getAnnotation(CrmExcelImport.class);
        Validate.notNull((Object)crmExcelImport, (String)"excel\u5bfc\u5165bean\u672a\u914d\u7f6eCrmExcelImport\u6ce8\u89e3", (Object[])new Object[0]);
        Field[] fields = ReflectUtil.getFields((Class)process.findCrmExcelVoClass());
        long count = Stream.of(fields).filter(a -> Objects.nonNull(a.getAnnotation(CrmExcelColumn.class))).count();
        Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"excel\u5bfc\u5165bean\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u914d\u7f6eCrmExcelColumn\u6ce8\u89e3", (Object[])new Object[0]);
        sw.start("3\u3001\u83b7\u53d6\u539f\u6587\u4ef6+\u6a21\u677f\u6587\u4ef6\u4fe1\u606f");
        HashMap downloadFileMap = Maps.newHashMap();
        OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(task.getFileCode());
        if (ordinaryFileVo != null) {
            downloadFileMap.put(task.getFileCode(), ordinaryFileVo);
        }
        if ((templateFileVo = this.fileHandleService.findById(templateFileCode)) != null) {
            downloadFileMap.put(templateFileCode, templateFileVo);
        }
        boolean fileFlag = downloadFileMap.containsKey(task.getFileCode()) && ((OrdinaryFileVo)downloadFileMap.get(task.getFileCode())).getFileSize() > 0L;
        Validate.isTrue((boolean)fileFlag, (String)CharSequenceUtil.format((CharSequence)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1{}\u5bf9\u5e94\u7684\u539f\u6587\u4ef6\u4fe1\u606f", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
        boolean templateFileFlag = downloadFileMap.containsKey(templateFileCode) && ((OrdinaryFileVo)downloadFileMap.get(templateFileCode)).getFileSize() > 0L;
        Validate.isTrue((boolean)templateFileFlag, (String)CharSequenceUtil.format((CharSequence)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1{}\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u4fe1\u606f", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
        sw.stop();
        sw.start("4\u3001\u5904\u7406excel\u5bfc\u5165");
        ImportExcelLocalFile localExcelFileMap = this.createLocalExcelFile(downloadFileMap, task.getFileCode(), templateFileCode, task.getTaskCode());
        String parentPath = localExcelFileMap.getOrdinaryFile().getParentPath();
        try {
            this.excelHandler(task, process, localExcelFileMap);
        }
        catch (Exception var22) {
            log.error("\u5bfc\u5165\u51fa\u9519\u4e86{},error[{}]", (Object)vo.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)var22));
            Validate.isTrue((boolean)false, (String)var22.getMessage(), (Object[])new Object[0]);
        }
        finally {
            FileUtil.del((String)parentPath);
        }
        sw.stop();
        log.info(CharSequenceUtil.format((CharSequence)"******\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}\uff0c\u6267\u884c\u7edf\u8ba1{}****", (Object[])new Object[]{vo.getTaskCode(), sw.prettyPrint()}));
    }

    private ImportExcelLocalFile createLocalExcelFile(Map<String, OrdinaryFileVo> downloadFileMap, String fileCode, String templateFileCode, String taskCode) {
        ImportExcelLocalFile localFile = new ImportExcelLocalFile();
        if (downloadFileMap != null && downloadFileMap.containsKey(fileCode) && downloadFileMap.containsKey(templateFileCode)) {
            OrdinaryFileVo ordinaryFileVo = downloadFileMap.get(fileCode);
            OrdinaryFileVo templateFileVo = downloadFileMap.get(templateFileCode);
            Date now = new Date();
            String root = this.importExportProperties.getRoot();
            if (StringUtils.isBlank((CharSequence)root)) {
                root = FileUtil.getTmpDirPath();
            }
            if (root.endsWith("/")) {
                root = root.substring(0, root.length() - 1);
            }
            String parentPath = CharSequenceUtil.format((CharSequence)"{}/import/{}/{}", (Object[])new Object[]{root, DateUtil.format((Date)now, (String)"yyyy/MM-dd"), fileCode});
            String originalFileName = ordinaryFileVo.getOriginalFileName();
            File ordinaryFile = new File(parentPath, originalFileName);
            String templateFileName = originalFileName.substring(0, originalFileName.lastIndexOf("."));
            templateFileName = templateFileName + "_" + ExcelFileTypeEnum.TEMPLATE.getValue() + ".xlsx";
            File templateFile = new File(parentPath, templateFileName);
            String errorFileName = this.crmExcelProcessStrategy.getErrorExcelFileName(originalFileName);
            File errorFile = new File(parentPath, errorFileName);
            CountDownLatch latch = new CountDownLatch(2);
            byte[] bytes = this.fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName());
            if (bytes != null) {
                byte[] finalBytes = bytes;
                Thread writeFileThread = new Thread(() -> {
                    File tmpFile = ordinaryFile;
                    try {
                        Thread.currentThread().setName("\u6587\u4ef6\u5199\u5165" + tmpFile);
                        FileUtil.writeBytes((byte[])finalBytes, (File)tmpFile);
                        ExcelFileVo vo = this.convertExcelFileVo(tmpFile);
                        localFile.setOrdinaryFile(vo);
                    }
                    catch (Exception var10) {
                        log.error("ERR230904-0101:\u5bfc\u5165\u6587\u4ef6\u5199\u5165\u5f02\u5e38:" + tmpFile, (Throwable)var10);
                    }
                    finally {
                        latch.countDown();
                    }
                });
                writeFileThread.start();
                bytes = this.fileHandleService.findContentByFilePathAndFileRename(templateFileVo.getRelativeLocal(), templateFileVo.getFileName());
                if (bytes != null) {
                    byte[] finalBytes1 = bytes;
                    writeFileThread = new Thread(() -> {
                        File tmpFile = templateFile;
                        try {
                            Thread.currentThread().setName("\u6587\u4ef6\u5199\u5165" + tmpFile);
                            FileUtil.writeBytes((byte[])finalBytes1, (File)tmpFile);
                            ExcelFileVo vo = this.convertExcelFileVo(tmpFile);
                            localFile.setTemplateFile(vo);
                        }
                        catch (Exception var10) {
                            log.error("ERR230904-0201:\u6a21\u677f\u6587\u4ef6\u5199\u5165\u5f02\u5e38:" + tmpFile, (Throwable)var10);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    writeFileThread.start();
                    ExcelFileVo errorFileExcelFileVo = this.convertExcelFileVo(errorFile);
                    localFile.setErrorFile(errorFileExcelFileVo);
                    try {
                        latch.await();
                    }
                    catch (InterruptedException var17) {
                        log.error("\u5199\u5165\u672c\u5730\u6587\u4ef6\u53d1\u751f\u5f02\u5e38{}", (Throwable)var17);
                        throw new RuntimeException("\u7b49\u5f85\u5199\u5165\u6587\u4ef6\u5f02\u5e38", var17);
                    }
                    Validate.isTrue((localFile.getOrdinaryFile() != null ? 1 : 0) != 0, (String)"ERR230904-0301:\u5bfc\u5165\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 %s", (Object[])new Object[]{taskCode});
                    Validate.isTrue((localFile.getTemplateFile() != null ? 1 : 0) != 0, (String)"ERR230904-0302:\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25 %s", (Object[])new Object[]{taskCode});
                    return localFile;
                }
                throw new RuntimeException("ERR230904-0202:\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u5f02\u5e38:" + ordinaryFileVo);
            }
            throw new RuntimeException("ERR230904-0102:\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38:" + ordinaryFileVo);
        }
        return localFile;
    }

    private ImportProcess findImportProcess(String code) {
        if (!CollectionUtils.isEmpty(this.importProcesses) && !StringUtils.isBlank((CharSequence)code)) {
            Optional<ImportProcess> op = this.importProcesses.stream().filter(item -> item.getTemplateCode().equals(code)).findFirst();
            Validate.notNull(op, (String)CharSequenceUtil.format((CharSequence)"\u672a\u83b7\u53d6\u5230\u6a21\u677f\u7f16\u7801{}\u5bf9\u5e94\u7684\u5904\u7406\u5668\u4fe1\u606f", (Object[])new Object[]{code}), (Object[])new Object[0]);
            return op.orElse(null);
        }
        return null;
    }

    private void excelHandler(ImportTask task, ImportProcess process, ImportExcelLocalFile localFile) {
        if (localFile == null || localFile.getOrdinaryFile() == null || localFile.getTemplateFile() == null) {
            Validate.isTrue((boolean)false, (String)"\u4efb\u52a1\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Object[])new Object[0]);
        }
        String taskCode = task.getTaskCode();
        StopWatch sw = new StopWatch(CharSequenceUtil.format((CharSequence)"====\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}-excel\u5904\u7406===", (Object[])new Object[]{taskCode}));
        Map<String, Object> params = this.findParamsMap(task);
        TaskGlobalParamsVo paramsVo = this.findParams(task);
        sw.start("excel\u903b\u8f91\u5904\u7406");
        ImportTaskHandlerResultVo resultVo = this.crmExcelProcessStrategy.importExcel(process, paramsVo, params, localFile);
        sw.stop();
        log.info(CharSequenceUtil.format((CharSequence)"+++++\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}-excel\u5904\u7406\uff0c\u6267\u884c\u7edf\u8ba1{}++++", (Object[])new Object[]{taskCode, sw.prettyPrint()}));
    }

    private Map<String, Object> findParamsMap(ImportTask importTask) {
        if (!Objects.isNull(importTask) && !StringUtils.isBlank((CharSequence)importTask.getParametersJson())) {
            HashMap map = Maps.newHashMap();
            JSONObject jsonObject = JSONUtil.parseObj((String)importTask.getParametersJson());
            Set set = jsonObject.keySet();
            for (String item : set) {
                map.put(item, jsonObject.get((Object)item));
            }
            return map;
        }
        return Maps.newHashMap();
    }

    private TaskGlobalParamsVo findParams(ImportTask task) {
        Validate.notNull((Object)task, (String)"\u5bfc\u5165\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        TaskGlobalParamsVo vo = new TaskGlobalParamsVo();
        vo.setAppCode(task.getAppCode());
        vo.setApplicationName(task.getApplicationName());
        vo.setCreateAccount(task.getCreateAccount());
        vo.setCreateAccountName(task.getCreateName());
        vo.setTaskCreateTime(task.getCreateTime());
        vo.setTenantCode(task.getTenantCode());
        vo.setTaskCode(task.getTaskCode());
        return vo;
    }

    private List<OrdinaryFileVo> venusFileUpload(MultipartFile multipartFile) throws IOException {
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setCreator(this.loginUserService.findCurrentAccount());
        base64UploadDto.setFileNanmes(new String[]{multipartFile.getOriginalFilename()});
        base64UploadDto.setBase64Contents(new String[]{Base64Utils.encodeToString((byte[])multipartFile.getBytes())});
        List ordinaryFileVoList = this.fileHandleService.fileUpload(this.subsystem.replace("-", "_"), base64UploadDto, (String)null);
        Validate.notEmpty((Collection)ordinaryFileVoList, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Object[])new Object[0]);
        return ordinaryFileVoList;
    }

    private ExcelFileVo convertExcelFileVo(File file) {
        ExcelFileVo vo = new ExcelFileVo();
        vo.setFileName(file.getName());
        vo.setParentPath(file.getParent());
        try {
            vo.setPath(file.getCanonicalPath());
        }
        catch (IOException var4) {
            vo.setPath(file.getPath());
        }
        return vo;
    }
}

