/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.login;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.event.sdk.service.NebulaNonWebHttpHeaderStrategy;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component
public class FeignHttpHeaderStrategy
implements NebulaNonWebHttpHeaderStrategy,
RequestInterceptor {
    @Autowired(required=false)
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public void fill(HttpHeaders httpHeaders) {
        AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
        if (Objects.isNull(userIdentity)) {
            this.loginUserService.refreshAuthentication(null);
            userIdentity = this.loginUserService.getAbstractLoginUser();
        }
        String jwtContent = JwtUtils.encode((UserIdentity)userIdentity, (int)0, (String)this.simpleSecurityProperties.getSecretKey());
        httpHeaders.add("jwt", jwtContent);
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        if (null != marsAuthorityContext && StringUtils.isNotBlank((CharSequence)marsAuthorityContext.getListCode())) {
            httpHeaders.add("Mars_list_code", marsAuthorityContext.getListCode());
        }
    }

    public void apply(RequestTemplate template) {
        AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
        if (Objects.isNull(userIdentity)) {
            this.loginUserService.refreshAuthentication(null);
            userIdentity = this.loginUserService.getAbstractLoginUser();
        }
        String jwtContent = JwtUtils.encode((UserIdentity)userIdentity, (int)0, (String)this.simpleSecurityProperties.getSecretKey());
        template.header("jwt", new String[]{jwtContent});
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        if (null != marsAuthorityContext && StringUtils.isNotBlank((CharSequence)marsAuthorityContext.getListCode())) {
            template.header("Mars_list_code", new String[]{marsAuthorityContext.getListCode()});
        }
    }
}

