/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RedisCrmService {
    private static final Logger log = LoggerFactory.getLogger(RedisCrmService.class);
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public Long incr(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Long incr(String key, long delta, TimeUnit timeUnit, long expireTime) {
        Long count = null;
        try {
            count = this.redisTemplate.opsForValue().increment((Object)key, delta);
            this.expire(key, timeUnit, expireTime);
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return count;
    }

    public Long decr(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Long decr(String key, long delta, TimeUnit timeUnit, long expireTime) {
        Long count = null;
        try {
            count = this.redisTemplate.opsForValue().increment((Object)key, -delta);
            this.expire(key, timeUnit, expireTime);
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return count;
    }

    public Boolean expire(String key, TimeUnit timeUnit, long time) {
        Assert.notNull((Object)((Object)timeUnit), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0!");
        return this.redisTemplate.expire((Object)key, time, timeUnit);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public List<Object> hmget(String key, Set<Object> item) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, item);
    }

    public Object hmget(String key, Object item) {
        return this.redisTemplate.opsForHash().get((Object)key, item);
    }

    public Boolean hmHasKey(String hash, Object key) {
        return this.redisTemplate.opsForHash().hasKey((Object)hash, key);
    }

    public Map<?, ?> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<?, ?> map, TimeUnit timeUnit, long time) {
        Assert.notNull((Object)((Object)timeUnit), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0!");
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            this.expire(key, timeUnit, time);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, TimeUnit timeUnit, long time) {
        Assert.notNull((Object)((Object)timeUnit), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0!");
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            this.expire(key, timeUnit, time);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, TimeUnit timeUnit, long time, Object ... values) {
        Assert.notNull((Object)((Object)timeUnit), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0!");
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            this.expire(key, timeUnit, time);
            return count;
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index, long time) {
        try {
            Object obj = this.redisTemplate.opsForList().index((Object)key, index);
            return obj;
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value, TimeUnit timeUnit, long time) {
        Assert.notNull((Object)((Object)timeUnit), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0!");
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            this.expire(key, timeUnit, time);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, Collection value, TimeUnit timeUnit, long time) {
        Assert.notNull((Object)((Object)timeUnit), (String)"\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0!");
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            this.expire(key, timeUnit, time);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public DataType type(String key) {
        return this.redisTemplate.type((Object)key);
    }
}

