/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.model.Result;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BusinessHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BusinessHttpUtil.class);
    public static final int ERROR_CODE = 20001;

    public static Result<String> post(String url, String json) {
        return BusinessHttpUtil.post(url, json, null, "application/json", 5, 120, null);
    }

    public static Result<String> post(String url, String json, Map<String, String> headMap) {
        return BusinessHttpUtil.post(url, json, headMap, "application/json", 5, 120, null);
    }

    public static Result<String> post(String url, Map<String, String> headMap, Map<String, Object> formMap) {
        return BusinessHttpUtil.post(url, null, headMap, "application/json", 5, 120, formMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> post(String url, String json, Map<String, String> headMap, String contentType, int connectionTimeout, int readTimeout, Map<String, Object> formMap) {
        Result result = new Result();
        HttpResponse httpResponse = null;
        try {
            log.info("http|https post request information,targetMain is [{}],contentType is [{}],head is [{}],json is [{}]", new Object[]{url, contentType, headMap == null ? null : JSON.toJSONString(headMap), json});
            HttpRequest httpRequest = BusinessHttpUtil.createRequest(url, json, Method.POST, headMap, contentType, connectionTimeout, readTimeout, formMap);
            httpResponse = httpRequest.execute();
            result.setCode(Integer.valueOf(httpResponse.getStatus()));
            result.setSuccess(CommonConstant.SC_OK_200.equals(result.getCode()));
            result.setResult((Object)httpResponse.body());
            if (!result.isSuccess()) {
                result.setMessage(httpResponse.body());
            }
            log.info("http|https post request return information [{}]", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.error("http|https post request  error ,contentType is [{}] seconds,connectionTimeout is [{}],readTimeout is [{}] seconds", new Object[]{contentType, connectionTimeout, readTimeout});
            log.error("http|https post request  error ,targetMain is [{}],head is [{}],body is [{}]", new Object[]{url, headMap == null ? null : JSON.toJSONString(headMap), json});
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setCode(Integer.valueOf(20001));
            result.setMessage(e.getMessage());
            log.error("http|https post request return information [{}]", (Object)JSON.toJSONString((Object)result));
        }
        finally {
            if (Objects.nonNull(httpResponse)) {
                httpResponse.close();
            }
        }
        return result;
    }

    public static Result<String> get(String url, String json) {
        return BusinessHttpUtil.get(url, json, null, "application/json", 5, 120);
    }

    public static Result<String> get(String url, String json, Map<String, String> headMap) {
        return BusinessHttpUtil.get(url, json, headMap, "application/json", 5, 120);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> get(String url, String json, Map<String, String> headMap, String contentType, int connectionTimeout, int readTimeout) {
        Result result = new Result();
        HttpResponse httpResponse = null;
        try {
            log.info("http|https get request information,targetMain is [{}],contentType is [{}],head is [{}],json is [{}]", new Object[]{url, contentType, headMap == null ? null : JSON.toJSONString(headMap), json});
            HttpRequest httpRequest = BusinessHttpUtil.createRequest(url, json, Method.GET, headMap, contentType, connectionTimeout, readTimeout, null);
            httpResponse = httpRequest.execute();
            result.setCode(Integer.valueOf(httpResponse.getStatus()));
            result.setSuccess(CommonConstant.SC_OK_200.equals(result.getCode()));
            result.setResult((Object)httpResponse.body());
            if (!result.isSuccess()) {
                result.setMessage(httpResponse.body());
            }
            log.info("http|https get request return information [{}]", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.error("http|https get request  error ,contentType is [{}] seconds,connectionTimeout is [{}],readTimeout is [{}] seconds", new Object[]{contentType, connectionTimeout, readTimeout});
            log.error("http|https get request  error ,targetMain is [{}],head is [{}],json is [{}]", new Object[]{url, headMap == null ? null : JSON.toJSONString(headMap), json});
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setCode(Integer.valueOf(20001));
            result.setMessage(e.getMessage());
            log.error("http|https get request return information [{}]", (Object)JSON.toJSONString((Object)result));
        }
        finally {
            if (Objects.nonNull(httpResponse)) {
                httpResponse.close();
            }
        }
        return result;
    }

    public static HttpRequest createRequest(String url, String json, Method method, Map<String, String> headMap, String contentType, int connectionTimeout, int readTimeout, Map<String, Object> formMap) {
        String realUrl = url;
        if (Method.GET.equals((Object)method)) {
            if (!url.endsWith("?")) {
                realUrl = realUrl + "?";
            }
            realUrl = realUrl + json;
        }
        HttpRequest httpRequest = HttpUtil.createRequest((Method)method, (String)realUrl);
        httpRequest.setConnectionTimeout(connectionTimeout * 1000);
        httpRequest.setReadTimeout(readTimeout * 1000);
        if (!CollectionUtils.isEmpty(headMap)) {
            httpRequest.addHeaders(headMap);
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            httpRequest.contentType(contentType);
        }
        if (Method.POST.equals((Object)method)) {
            if ("application/json".equals(contentType)) {
                httpRequest.body(json);
            } else if (Objects.nonNull(formMap)) {
                httpRequest.form(formMap);
            }
        }
        return httpRequest;
    }
}

