/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import io.swagger.annotations.ApiModelProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTooLongExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(DataTooLongExceptionUtil.class);
    private static final Pattern PATTERN = Pattern.compile("Data too long for column '.*'");

    public static String generateRespStr(Exception e, Class<?> entityClass) {
        if (entityClass == null) {
            return e.getMessage();
        }
        Matcher matcher = PATTERN.matcher(e.getMessage());
        if (matcher.find()) {
            String columnName = matcher.group(0).replace("Data too long for column ", "").replaceAll("'", "").toLowerCase();
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                return e.getMessage();
            }
            try {
                Field[] fields;
                for (Field field : fields = entityClass.getDeclaredFields()) {
                    Annotation[] annotations = field.getDeclaredAnnotations();
                    ApiModelProperty apiModelProperty = null;
                    for (Annotation annotation : annotations) {
                        if (!(annotation instanceof ApiModelProperty)) continue;
                        apiModelProperty = (ApiModelProperty)annotation;
                    }
                    for (Annotation annotation : annotations) {
                        Column column;
                        if (!(annotation instanceof Column) || !columnName.equals((column = (Column)annotation).name())) continue;
                        if (apiModelProperty != null) {
                            if (StringUtils.isNotEmpty((CharSequence)apiModelProperty.value())) {
                                return "\u5b57\u6bb5\u3010" + apiModelProperty.value() + "\u3011\u957f\u5ea6\u8fc7\u957f\uff0c\u6700\u5927\u957f\u5ea6\u9650\u5236\u4e3a" + column.length();
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)apiModelProperty.name())) continue;
                            return "\u5b57\u6bb5\u3010" + apiModelProperty.name() + "\u3011\u957f\u5ea6\u8fc7\u957f\uff0c\u6700\u5927\u957f\u5ea6\u9650\u5236\u4e3a" + column.length();
                        }
                        return "\u5b57\u6bb5\u3010" + column.columnDefinition().toLowerCase().replaceAll("'", "").replaceAll("comment", "") + "\u3011\u957f\u5ea6\u8fc7\u957f\uff0c\u6700\u5927\u957f\u5ea6\u9650\u5236\u4e3a" + column.length();
                    }
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            return e.getMessage();
        }
        return e.getMessage();
    }
}

