/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class NumberDealUtil {
    public static BigDecimal decimalSum(BigDecimal ... decimals) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal decimal : decimals) {
            if (!Objects.nonNull(decimal)) continue;
            result = result.add(decimal);
        }
        return result;
    }

    public static void setStringIfNotNull(Object obj, Consumer<String> setMethod) {
        if (null != obj) {
            setMethod.accept(obj.toString());
        }
    }

    public static <T> void validateNumberStrAndSet(String str, String desc, Consumer<T> setMethod, Class<T> cls) {
        NumberDealUtil.validateNumberStrAndSet(str, desc, true, setMethod, cls);
    }

    public static <T> void validateNumberStrAndSet(String str, String desc, boolean required, Consumer<T> setMethod, Class<T> cls) {
        String errorMsg = NumberDealUtil.validateNumberStrAndSetErrorMsg(str, desc, required, setMethod, cls);
        Assert.isTrue((boolean)StringUtils.isEmpty((CharSequence)errorMsg), (String)errorMsg);
    }

    public static <T> String validateNumberStrAndSetErrorMsg(String str, String desc, Consumer<T> setMethod, Class<T> cls) {
        return NumberDealUtil.validateNumberStrAndSetErrorMsg(str, desc, true, setMethod, cls);
    }

    public static <T> String validateNumberStrAndSetErrorMsg(String str, String desc, boolean required, Consumer<T> setMethod, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)str)) {
            if (required) {
                return desc + "\u4e0d\u80fd\u4e3a\u7a7a||";
            }
            return "";
        }
        try {
            Number value = null;
            if (cls == Integer.class) {
                value = Integer.valueOf(str.trim());
            } else if (cls == BigDecimal.class) {
                value = new BigDecimal(str.trim());
            }
            setMethod.accept((Integer)value);
            return "";
        }
        catch (NumberFormatException e) {
            return desc + "[" + str + "]\u683c\u5f0f\u6709\u8bef||";
        }
    }
}

