/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.base.webservice.ZPI_SERVERS_SOAStub;
import com.biz.crm.business.common.sdk.model.Result;
import java.rmi.RemoteException;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.impl.httpclient3.HttpTransportPropertiesImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

@Component
public class SapUtils {
    private static final Logger log = LoggerFactory.getLogger(SapUtils.class);
    @Value(value="${sap.newwebserviceclient:}")
    private String newwebserviceclient;
    @Value(value="${sap.webserviceclient:}")
    private String webserviceclient;
    @Value(value="${sap.new_sap_username:}")
    private String new_sap_username;
    @Value(value="${sap.new_sap_password:}")
    private String new_sap_password;

    public Result restPostcore(JSONObject jsonstr) {
        Result head = new Result();
        try {
            Object rt;
            head = this.shareFromSap(jsonstr);
            log.info("====SapUtils==restPostcore========={}", (Object)JSON.toJSONString((Object)head));
            if (StringUtils.isBlank((CharSequence)head.getMessage())) {
                head.setSuccess(false);
                head.setMessage("\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
                return head;
            }
            JSONObject obc = JSONObject.parseObject((String)head.getMessage());
            JSONArray s = obc.getJSONArray("ITABLE");
            if (s != null && (rt = s.getJSONObject(0).get((Object)"MTYPE")) != null && rt.equals("E")) {
                head.setSuccess(false);
            }
        }
        catch (RestClientException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return head;
    }

    public Result restNewPostCore(JSONObject jsonstr) {
        Result head = Result.ok();
        try {
            Object rt;
            head = this.shareFromNewSap(jsonstr);
            log.info("====SapUtils==restPostcore========={}", (Object)JSON.toJSONString((Object)head));
            JSONObject obc = JSONObject.parseObject((String)head.getMessage());
            JSONArray s = obc.getJSONArray("ITABLE");
            if (s != null && (rt = s.getJSONObject(0).get((Object)"MTYPE")) != null && rt.equals("E")) {
                head.setSuccess(false);
            }
        }
        catch (RestClientException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return head;
    }

    private Result shareFromNewSap(JSONObject in_json) {
        Result head = new Result();
        try {
            ZPI_SERVERS_SOAStub stub = new ZPI_SERVERS_SOAStub(this.newwebserviceclient);
            HttpTransportPropertiesImpl.Authenticator authenticator = new HttpTransportPropertiesImpl.Authenticator();
            authenticator.setUsername(this.new_sap_username);
            authenticator.setPassword(this.new_sap_password);
            stub._getServiceClient().getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
            stub._getServiceClient().getOptions().setProperty("CHARACTER_SET_ENCODING", (Object)"utf-8");
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)new Integer(300000));
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)new Integer(300000));
            stub._getServiceClient().getOptions().setProperty("HTTP_METHOD", (Object)"POST");
            stub._getServiceClient().getOptions().setProperty("Connection", (Object)HTTPConstants.HEADER_CONNECTION_CLOSE);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC async = new ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC();
            ZPI_SERVERS_SOAStub.String strJson = new ZPI_SERVERS_SOAStub.String();
            strJson.setString(in_json != null ? in_json.toJSONString() : "");
            async.setIN_JSON(strJson);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNCResponse response = stub.zIF_DATA_TO_SAP_SYNC(async);
            head.setSuccess(true);
            head.setMessage(response.getOUT_JSON().toString());
            stub._getServiceClient().cleanupTransport();
            stub._getServiceClient().cleanup();
            stub.cleanup();
            stub = null;
        }
        catch (RemoteException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return head;
    }

    private Result shareFromSap(JSONObject in_json) {
        Result head = new Result();
        try {
            ZPI_SERVERS_SOAStub stub = new ZPI_SERVERS_SOAStub(null, this.webserviceclient);
            HttpTransportPropertiesImpl.Authenticator authenticator = new HttpTransportPropertiesImpl.Authenticator();
            authenticator.setUsername(this.new_sap_username);
            authenticator.setPassword(this.new_sap_password);
            stub._getServiceClient().getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
            stub._getServiceClient().getOptions().setProperty("CHARACTER_SET_ENCODING", (Object)"utf-8");
            stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)new Integer(300000));
            stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)new Integer(300000));
            stub._getServiceClient().getOptions().setProperty("HTTP_METHOD", (Object)"POST");
            stub._getServiceClient().getOptions().setProperty("Connection", (Object)HTTPConstants.HEADER_CONNECTION_CLOSE);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC async = new ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC();
            ZPI_SERVERS_SOAStub.String strJson = new ZPI_SERVERS_SOAStub.String();
            strJson.setString(in_json != null ? in_json.toJSONString() : "");
            async.setIN_JSON(strJson);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNCResponse response = stub.zIF_DATA_TO_SAP_SYNC(async);
            head.setSuccess(true);
            head.setMessage(response.getOUT_JSON().toString());
            stub._getServiceClient().cleanupTransport();
            stub._getServiceClient().cleanup();
            stub.cleanup();
            stub = null;
        }
        catch (RemoteException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return head;
    }
}

