/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(SignHeaderUtil.class);

    public static Map<String, String> getSignHeadMap(String accessKey, String secretKey, String interfaceAddress) {
        HashMap headMap = Maps.newHashMap();
        headMap.put("version", "2.0.0");
        String timestampStr = System.currentTimeMillis() + "";
        String alg = "MD5";
        JSONObject authJson = new JSONObject();
        authJson.put("timestamp", (Object)timestampStr);
        authJson.put("appKey", (Object)accessKey);
        authJson.put("alg", (Object)alg);
        headMap.put("Authorization", SignHeaderUtil.signAuthorization(authJson.toJSONString(), interfaceAddress, secretKey));
        return headMap;
    }

    public static String signAuthorization(String headerJson, String interfaceAddress, String secretKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n=====>    RySignHeaderUtil BASE64 key:     [").append(headerJson).append("]     <=====\n ");
        String base64Value = Base64.encode((CharSequence)headerJson, (Charset)StandardCharsets.UTF_8);
        stringBuilder.append("=====>    RySignHeaderUtil base64Value:     [").append(headerJson).append("]     <=====\n");
        String md5Key = base64Value + interfaceAddress + secretKey;
        stringBuilder.append("=====>    RySignHeaderUtil md5Key:     [").append(headerJson).append("]     <=====\n");
        String md5Value = MD5.create().digestHex(md5Key, StandardCharsets.UTF_8).toUpperCase();
        stringBuilder.append("=====>    RySignHeaderUtil md5Value:     [").append(headerJson).append("]     <=====\n");
        log.info(stringBuilder.toString());
        return base64Value + "." + md5Value;
    }
}

