package com.biz.crm.business.common.base.login;

import com.biz.crm.business.common.base.constant.BusinessConstant;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.event.sdk.service.NebulaNonWebHttpHeaderStrategy;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 子线程中调用事件问题
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023.1.18 3:02
 */
@Component
public class FeignHttpHeaderStrategy implements NebulaNonWebHttpHeaderStrategy,
        RequestInterceptor {
    @Autowired(required = false)
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    public void fill(HttpHeaders httpHeaders) {
        AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
        if (Objects.isNull(userIdentity)){
            loginUserService.refreshAuthentication(null);
            userIdentity = loginUserService.getAbstractLoginUser();
        }
        String jwtContent = JwtUtils.encode(userIdentity, 0, simpleSecurityProperties.getSecretKey());
        httpHeaders.add(BusinessConstant.JWT, jwtContent);
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        if (null != marsAuthorityContext && StringUtils.isNotBlank(marsAuthorityContext.getListCode())) {
            httpHeaders.add("Mars_list_code", marsAuthorityContext.getListCode());
        }
    }

    @Override
    public void apply(RequestTemplate template) {
        AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
        if (Objects.isNull(userIdentity)){
            loginUserService.refreshAuthentication(null);
            userIdentity = loginUserService.getAbstractLoginUser();
        }
        String jwtContent = JwtUtils.encode(userIdentity, 0, simpleSecurityProperties.getSecretKey());
        template.header(BusinessConstant.JWT, jwtContent);
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        if (null != marsAuthorityContext && StringUtils.isNotBlank(marsAuthorityContext.getListCode())) {
            template.header("Mars_list_code", marsAuthorityContext.getListCode());
        }
    }
}