/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.aspect;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.base.vo.WebLogVo;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);
    protected static final ThreadLocal<ConcurrentHashMap<String, WebLogVo>> THREAD_LOCAL_REQ = new ThreadLocal();
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String TIP_MSG = "\u672a\u83b7\u53d6\u5230\u5165\u53c2\u4fe1\u606f";

    @Pointcut(value="execution(public * com..*.controller..*.*(..))")
    public void openApiLog() {
    }

    @Before(value="openApiLog()")
    public void doBefore(JoinPoint joinPoint) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = null;
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            if (requestAttributes != null) {
                request = requestAttributes.getRequest();
            }
            WebLogVo logVo = new WebLogVo();
            logVo.setUuid(uuid);
            logVo.setTime(System.currentTimeMillis());
            this.addLogVo(logVo);
            AbstractCrmUserIdentity loginDetails = Objects.nonNull(this.loginUserService) ? this.loginUserService.getAbstractLoginUser() : null;
            log.info("[AOP\u8bf7\u6c42\u65e5\u5fd7]:\n \u8bf7\u6c42\u552f\u4e00\u6807\u8bb0:[{}] \n \u8bf7\u6c42\u7528\u6237:[{}]", (Object)uuid, (Object)(Objects.isNull(loginDetails) ? "\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f" : JSON.toJSONString((Object)loginDetails)));
            if (request != null) {
                String contentType = request.getContentType();
                Class<?> clazz = joinPoint.getTarget().getClass();
                Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
                ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
                HashMap<String, String> map = new HashMap<String, String>(32);
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String key = (String)headerNames.nextElement();
                    String value = request.getHeader(key);
                    map.put(key, value);
                }
                String bodyData = TIP_MSG;
                if (Objects.nonNull(joinPoint.getArgs())) {
                    Object[] args = joinPoint.getArgs();
                    Object[] arguments = new Object[args.length];
                    if (args.length == 1) {
                        bodyData = JSON.toJSONString((Object)args[0]);
                    } else {
                        for (int i = 0; i < args.length; ++i) {
                            if (args[i] instanceof ServletRequest || args[i] instanceof ServletResponse || args[i] instanceof MultipartFile) continue;
                            arguments[i] = args[i];
                        }
                        bodyData = JSON.toJSONString((Object)arguments);
                    }
                } else {
                    HashMap<String, String> dataMap = new HashMap<String, String>(16);
                    Enumeration enu = request.getParameterNames();
                    while (enu.hasMoreElements()) {
                        String paraName = (String)enu.nextElement();
                        String paraValue = request.getParameter(paraName);
                        dataMap.put(paraName, paraValue);
                    }
                    bodyData = JSON.toJSONString(dataMap);
                }
                log.info("[AOP\u8bf7\u6c42\u65e5\u5fd7]:\n \u8bf7\u6c42\u552f\u4e00\u6807\u8bb0:[{}] \n apiOperation\u6ce8\u91ca:[{}] \n \u8bf7\u6c42\u65b9\u5f0f:[{}] \n contentType:[{}] \n uri:[{}]  \n \u65b9\u6cd5:[{}.{}] \n header\u5165\u53c2:{} \n body\u5165\u53c2:{}", new Object[]{uuid, Objects.isNull(apiOperation) ? "\u65e0\u6ce8\u91ca" : apiOperation.value(), request.getMethod(), contentType, clazz.getName(), request.getRequestURI(), method.getName(), map, bodyData});
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @AfterReturning(value="openApiLog()", returning="result")
    public void AfterReturning(Object result) {
        try {
            String msg;
            WebLogVo logVo = this.getLogVo();
            String uuid = Objects.isNull(logVo) ? TIP_MSG : logVo.getUuid();
            String string = msg = Objects.isNull(logVo) ? TIP_MSG : WebLogAspect.millisecondToStr(System.currentTimeMillis() - logVo.getTime());
            if (result != null) {
                if (result instanceof Result) {
                    log.info("[AOP\u8fd4\u56de\u65e5\u5fd7]: \u8bf7\u6c42\u552f\u4e00\u6807\u8bb0[{}] \u5904\u7406\u8017\u65f6[{}] \n Result\u7c7b\u578b[{}]", new Object[]{uuid, msg, JSON.toJSONString((Object)result)});
                } else {
                    HttpServletResponse response;
                    ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (requestAttributes != null && (response = requestAttributes.getResponse()) != null && "application/json".equals(response.getContentType())) {
                        log.info("[AOP\u8fd4\u56de\u65e5\u5fd7]: \u8bf7\u6c42\u552f\u4e00\u6807\u8bb0[{}] \u5904\u7406\u8017\u65f6[{}] \n \u975eResult\u7c7b\u578b[{}]", new Object[]{uuid, msg, JSON.toJSONString((Object)result)});
                    }
                }
            } else {
                log.info("[AOP\u8fd4\u56de\u65e5\u5fd7]: \u8bf7\u6c42\u552f\u4e00\u6807\u8bb0[{}] \u5904\u7406\u8017\u65f6[{}] \n \u8fd4\u56de\u6570\u636e\u4e3a null", (Object)uuid, (Object)msg);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @AfterThrowing(value="openApiLog()", throwing="e")
    public void AfterThrowing(Exception e) {
        try {
            WebLogVo logVo = this.getLogVo();
            String uuid = Objects.isNull(logVo) ? TIP_MSG : logVo.getUuid();
            String msg = Objects.isNull(logVo) ? TIP_MSG : WebLogAspect.millisecondToStr(System.currentTimeMillis() - logVo.getTime());
            log.info("[AOP\u8fd4\u56de\u65e5\u5fd7]:\u8bf7\u6c42\u552f\u4e00\u6807\u8bb0[{}] \u5904\u7406\u8017\u65f6[{}]  \n \u5f02\u5e38\u4fe1\u606f:{}", new Object[]{uuid, msg, e.getMessage()});
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addLogVo(WebLogVo respVo) {
        Thread thread = Thread.currentThread();
        ConcurrentHashMap<String, WebLogVo> logMap = THREAD_LOCAL_REQ.get();
        if (logMap == null) {
            logMap = new ConcurrentHashMap(16);
        }
        logMap.put(thread.getName() + "_" + thread.getId(), respVo);
        THREAD_LOCAL_REQ.set(logMap);
    }

    private WebLogVo getLogVo() {
        Thread thread = Thread.currentThread();
        ConcurrentHashMap<String, WebLogVo> logMap = THREAD_LOCAL_REQ.get();
        if (logMap == null) {
            logMap = new ConcurrentHashMap(16);
        }
        String key = thread.getName() + "_" + thread.getId();
        WebLogVo respVo = logMap.get(key);
        logMap.remove(key);
        THREAD_LOCAL_REQ.set(logMap);
        return respVo;
    }

    private static String millisecondToStr(long millisecond) {
        long days = millisecond / 86400000L;
        long hours = millisecond % 86400000L / 3600000L;
        long minute = millisecond % 86400000L % 3600000L / 60000L;
        long second = millisecond % 86400000L % 3600000L % 60000L / 1000L;
        long millisecondStr = millisecond % 86400000L % 3600000L % 60000L % 1000L;
        String spendTimes = "";
        if (days > 0L) {
            spendTimes = spendTimes + days + "\u5929";
        }
        if (hours > 0L) {
            spendTimes = spendTimes + hours + "\u5c0f\u65f6";
        }
        if (minute > 0L) {
            spendTimes = spendTimes + minute + "\u5206\u949f";
        }
        if (second > 0L) {
            spendTimes = spendTimes + second + "\u79d2";
        }
        if (millisecondStr > 0L || StringUtils.isEmpty((CharSequence)spendTimes)) {
            spendTimes = spendTimes + millisecondStr + "\u6beb\u79d2";
        }
        return spendTimes;
    }
}

