/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.config;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration
public class NebulaEventRestTemplateConfig {
    @Autowired(required=false)
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @LoadBalanced
    @Bean(value={"nebulaEventRestTemplate"})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setInterceptors((List)Lists.newArrayList((Object[])new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            HttpHeaders headers = request.getHeaders();
            if (!headers.containsKey((Object)"jwt")) {
                AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
                if (Objects.isNull(userIdentity)) {
                    this.loginUserService.refreshAuthentication(null);
                    userIdentity = this.loginUserService.getAbstractLoginUser();
                }
                String jwtContent = JwtUtils.encode((UserIdentity)userIdentity, (int)0, (String)this.simpleSecurityProperties.getSecretKey());
                headers.add("jwt", jwtContent);
            }
            return execution.execute(request, body);
        }}));
        return restTemplate;
    }
}

