/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.task;

import com.biz.crm.business.common.base.config.ExportTaskConfig;
import com.biz.crm.business.common.base.service.RedisLockService;
import com.biz.crm.business.common.base.util.DateUtil;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class ExportTaskCornTask
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskCornTask.class);
    private static final String DEFAULT_CRON = "0 2/30 * * * ?";
    private String cron = "0 2/30 * * * ?";
    @Resource
    private ExportTaskConfig exportTaskConfig;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private JdbcTemplate jdbcTemplate;
    @Value(value="${spring.jpa.database:}")
    private String databaseType;

    @PostConstruct
    private void setDeleteMqLogCron() {
        this.setCron(this.exportTaskConfig.getCleanCron());
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::exportTask, triggerContext -> {
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public void setCron(String cron) {
        log.info("====>     \u5bfc\u51fa\u5f02\u5e38\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u4efb\u52a1:\u539f\u6765\u7684cron\uff1a[{}]]\u66f4\u65b0\u540e\u7684cron\uff1a[{}]     <=====", (Object)this.cron, (Object)cron);
        this.cron = cron;
    }

    public String getCron() {
        return this.cron;
    }

    private void exportTask() {
        String lockKey;
        block16: {
            boolean lock;
            if (Objects.isNull(this.exportTaskConfig.getIsOpen()) || !this.exportTaskConfig.getIsOpen().booleanValue() || StringUtils.isEmpty((CharSequence)this.databaseType)) {
                return;
            }
            if (!Database.MYSQL.name().equalsIgnoreCase(this.databaseType) && !Database.ORACLE.name().equalsIgnoreCase(this.databaseType)) {
                return;
            }
            lockKey = "export:task:lock:" + this.exportTaskConfig.getAppName();
            if (this.redisLockService != null && !(lock = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L))) {
                return;
            }
            String mainTableName = "ie_export_task";
            String detailTableName = "ie_export_task_detail";
            Integer hour = Objects.isNull(this.exportTaskConfig.getSaveHour()) ? 4 : this.exportTaskConfig.getSaveHour();
            Date startDate = DateUtil.dateAddDay(new Date(), -1);
            Date endDate = DateUtil.dateAddHour(new Date(), -hour.intValue());
            String startDateStr = DateUtil.date_yyyy_MM_dd_HH_mm_ss.format(startDate);
            String endDateStr = DateUtil.date_yyyy_MM_dd_HH_mm_ss.format(endDate);
            if (Database.MYSQL.name().equalsIgnoreCase(this.databaseType)) {
                mainTableName = mainTableName.toLowerCase();
                detailTableName = detailTableName.toLowerCase();
                try {
                    String sql = "SELECT SCHEMA()";
                    String schemaName = (String)this.jdbcTemplate.queryForObject(sql, String.class);
                    if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
                        sql = "SELECT IF(EXISTS (SELECT 1     FROM INFORMATION_SCHEMA.TABLES     WHERE TABLE_SCHEMA = '" + schemaName + "' AND TABLE_NAME = '" + mainTableName + "'  ),'1','0') AS 'table_Status'";
                        String tableExit = (String)this.jdbcTemplate.queryForObject(sql, String.class);
                        if (StringUtils.isNotEmpty((CharSequence)tableExit) && "1".equals(tableExit)) {
                            sql = "UPDATE " + mainTableName + " t  SET t.exec_status = '25'  WHERE t.create_time >'" + startDateStr + "' and t.create_time <'" + endDateStr + "' AND t.exec_status in ('0','5')";
                            int count = this.jdbcTemplate.update(sql);
                            sql = "UPDATE " + detailTableName + " t  SET t.exec_status = '25'  WHERE t.create_time >'" + startDateStr + "' and t.create_time <'" + endDateStr + "' AND t.exec_status in ('0','5')";
                            count = this.jdbcTemplate.update(sql);
                            sql = "UPDATE " + detailTableName + " t  SET t.load_status = '1'  WHERE t.create_time >'" + startDateStr + "' and t.create_time <'" + endDateStr + "' AND t.load_status  = '0'";
                            count = this.jdbcTemplate.update(sql);
                            log.info("=====>    {} \u5bfc\u51fa\u5f02\u5e38\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u6267\u884c\u5b8c\u6210!    <=====", (Object)this.databaseType);
                        } else {
                            log.info("=====>    {} \u5bfc\u51fa\u5f02\u5e38\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u672a\u6267\u884c1,\u65e0\u5bfc\u51fa\u529f\u80fd!    <=====", (Object)this.databaseType);
                        }
                        break block16;
                    }
                    log.info("=====>    {} \u5bfc\u51fa\u5f02\u5e38\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u672a\u6267\u884c2,\u65e0\u5bfc\u51fa\u529f\u80fd!    <=====", (Object)this.databaseType);
                }
                catch (Exception e) {
                    log.error("=====>    {} \u5f02\u5e38\u5bfc\u51fa\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u4efb\u52a1\u72b6\u6001\u672a\u5931\u8d25\u5f02\u5e38    <=====", (Object)this.databaseType);
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else if (Database.ORACLE.name().equalsIgnoreCase(this.databaseType)) {
                mainTableName = mainTableName.toUpperCase();
                detailTableName = detailTableName.toUpperCase();
                try {
                    String sql = "SELECT table_name FROM user_tables WHERE table_name = '" + mainTableName + "'";
                    String tableExit = (String)this.jdbcTemplate.queryForObject(sql, String.class);
                    if (StringUtils.isNotEmpty((CharSequence)tableExit)) {
                        sql = "UPDATE " + mainTableName + " t  SET t.exec_status = '25'  WHERE t.create_time > to_date('" + startDateStr + "', 'yyyy-MM-dd HH24:MI:SS') and t.create_time < to_date('" + endDateStr + "', 'yyyy-MM-dd HH24:MI:SS') AND t.exec_status in ('0','5')";
                        int count = this.jdbcTemplate.update(sql);
                        sql = "UPDATE " + detailTableName + " t  SET t.exec_status = '25'  WHERE t.create_time > to_date('" + startDateStr + "', 'yyyy-MM-dd HH24:MI:SS') and t.create_time < to_date('" + endDateStr + "', 'yyyy-MM-dd HH24:MI:SS') AND t.exec_status in ('0','5')";
                        count = this.jdbcTemplate.update(sql);
                        sql = "UPDATE " + detailTableName + " t  SET t.load_status = '1'  WHERE t.create_time > to_date('" + startDateStr + "', 'yyyy-MM-dd HH24:MI:SS') and t.create_time < to_date('" + endDateStr + "', 'yyyy-MM-dd HH24:MI:SS') AND t.load_status  = '0'";
                        count = this.jdbcTemplate.update(sql);
                        log.info("=====>    {} \u5bfc\u51fa\u5f02\u5e38\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u6267\u884c\u5b8c\u6210!    <=====", (Object)this.databaseType);
                    } else {
                        log.info("=====>    {} \u5bfc\u51fa\u5f02\u5e38\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u672a\u6267\u884c1,\u65e0\u5bfc\u51fa\u529f\u80fd!    <=====", (Object)this.databaseType);
                    }
                }
                catch (Exception e) {
                    log.error("=====>    {} \u5f02\u5e38\u5bfc\u51fa\u4efb\u52a1\u81ea\u52a8\u91cd\u7f6e\u4efb\u52a1\u72b6\u6001\u672a\u5931\u8d25\u5f02\u5e38    <=====", (Object)this.databaseType);
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.redisLockService != null) {
            this.redisLockService.unlock(lockKey);
        }
    }
}

