/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BusinessBeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BusinessBeanUtils.class);

    public static <T> List<T> mapListToBeanList(List<Map<String, Object>> mapList, Class<T> cls, boolean throwException) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(cls);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        ArrayList list = Lists.newArrayList();
        for (Map<String, Object> objectMap : mapList) {
            Object t = null;
            try {
                t = cls.newInstance();
                list.add(t);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (!throwException) continue;
                throw new RuntimeException("\u5b9e\u4f8b" + cls + "\u521d\u59cb\u5316\u5931\u8d25");
            }
            for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                PropertyDescriptor propertyDescriptor;
                if (null == entry.getValue() || null == (propertyDescriptor = (PropertyDescriptor)propertyMap.get(entry.getKey()))) continue;
                try {
                    Object value = entry.getValue();
                    if (BigDecimal.class == propertyDescriptor.getPropertyType()) {
                        value = new BigDecimal(value.toString());
                    } else if (Integer.class == propertyDescriptor.getPropertyType()) {
                        value = Integer.parseInt(value.toString());
                    }
                    propertyDescriptor.getWriteMethod().invoke(t, value);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    if (!throwException) continue;
                    throw new RuntimeException("\u5c5e\u6027[" + propertyDescriptor.getName() + "]\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        return list;
    }
}

