/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.biz.crm.business.common.sdk.utils.HttpServletRequestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final String UNKNOWN = "unknown";
    private static final String[] CMDS = new String[]{"curl", "icanhazip.com"};

    public static String findRequestIp() {
        return IpUtils.findRequestIp(HttpServletRequestUtil.getRequest());
    }

    public static String findRequestIp(HttpServletRequest request) {
        if (request == null) {
            try {
                return IpUtils.findLocalPublicIp();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return "127.0.0.1";
            }
        }
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String findPublicIp() {
        ProcessBuilder process = new ProcessBuilder(CMDS);
        try {
            Process p = process.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            return builder.toString();
        }
        catch (IOException e) {
            log.error("\u67e5\u8be2\u672c\u673a\u516c\u7f51[{}]IP\u5931\u8d25!", (Object[])CMDS);
            log.error(e.getMessage(), (Throwable)e);
            return "127.0.0.1";
        }
    }

    public static String findLocalPublicIp() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u672c\u673a\u516c\u7f51IP\u5931\u8d25!");
            log.error(e.getMessage(), (Throwable)e);
            return IpUtils.findLocalInternalIp();
        }
    }

    public static String findLocalInternalIp() {
        try {
            return com.bizunited.nebula.common.util.IpUtils.findInternalIp();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u672c\u673a\u5185\u7f51IP\u5931\u8d25!");
            log.error(e.getMessage(), (Throwable)e);
            return "127.0.0.1";
        }
    }
}

