/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.base.util.StringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JsonPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonPropertyUtil.class);

    public static <T> T toObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Assert.notNull(clazz, (String)"class\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            log.error("json\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toArray(String json, Class<T> clazz) {
        if (StringUtil.isEmpty(json)) {
            return null;
        }
        Assert.notNull(clazz, (String)"class\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            JavaType type = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            log.error("json\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static String toJsonString(Object object) {
        if (Objects.isNull(object)) {
            return "";
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
            objectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
            objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    if (value == null) {
                        gen.writeString("");
                    }
                }
            });
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("json\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String toJsonStringNotEmptyVal(Object object) {
        if (Objects.isNull(object)) {
            return "";
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
            objectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("json\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static <T> T toObject(Map<String, Object> map, Class<T> clazz) {
        try {
            map = map == null ? Maps.newHashMap() : map;
            String content = JSON.toJSONString((Object)map);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            return (T)objectMapper.readValue(content, clazz);
        }
        catch (Exception e) {
            log.error("json\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

