/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String obj2json(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> T json2pojo(String jsonStr, Class<T> clazz) throws Exception {
        return (T)objectMapper.readValue(jsonStr, clazz);
    }

    public static <T> Map<String, Object> json2map(String jsonStr) throws Exception {
        return (Map)objectMapper.readValue(jsonStr, Map.class);
    }

    public static <T> Map<String, T> json2map(String jsonStr, Class<T> clazz) throws Exception {
        Map map = (Map)objectMapper.readValue(jsonStr, new TypeReference<Map<String, T>>(){});
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), JsonUtil.map2pojo((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static <T> List<T> json2list(String jsonArrayStr, Class<T> clazz) throws Exception {
        List list = (List)objectMapper.readValue(jsonArrayStr, new TypeReference<List<T>>(){});
        ArrayList<T> result = new ArrayList<T>();
        for (Map map : list) {
            result.add(JsonUtil.map2pojo(map, clazz));
        }
        return result;
    }

    public static <T> T map2pojo(Map map, Class<T> clazz) {
        return (T)objectMapper.convertValue((Object)map, clazz);
    }
}

