/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import cn.hutool.core.img.gif.AnimatedGifEncoder;
import com.biz.crm.business.common.base.vo.QRCode;
import com.swetake.util.Qrcode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.data.QRCodeImage;
import org.springframework.core.io.ClassPathResource;
import sun.misc.BASE64Encoder;

public class QRCodeEncoder {
    public static void main(String[] args) throws Exception {
        String imgPath = "D:/101.jpg";
        String content = "MECARD:N:\u9648\u751f;TIL:\u6280\u672f\u603b\u4e34;TEL:18912345678;ORG:\u4e2d\u56fd\u79d1\u5b66\u5f00\u53d1\u9662;EMAIL:chen@shaojian.com;ADR:\u6df1\u5733\u5e02\u5357\u5c71\u533a\u9ad8\u65b0\u5357\u4e00\u90532001\u53f7;URL:http://www.badu.com;";
        QRCodeEncoder encoder = new QRCodeEncoder();
        QRCode qrCode = new QRCode();
        qrCode.setTopText("123456666666");
        qrCode.setContent(content);
        qrCode.setImgPath(imgPath);
        encoder.encoderQRCode(qrCode);
        System.out.println("ok");
    }

    public void encoderQRCode(String content, String imgPath, String imgType, String charater, Integer size, Integer border, Color front, Color back, Integer scale, String logoPath, String animtePath) {
        try {
            if (this.isNull(content)) {
                content = "test";
            }
            if (this.isNull(imgPath)) {
                imgPath = "c:/test.png";
            }
            if (this.isNull(imgType)) {
                imgType = "png";
            }
            if (this.isNull(charater)) {
                charater = "UTF-8";
            }
            if (this.isNull(size)) {
                size = 4;
            }
            if (this.isNull(border)) {
                border = 10;
            }
            if (this.isNull(front)) {
                front = Color.BLACK;
            }
            if (this.isNull(back)) {
                back = Color.WHITE;
            }
            if (this.isNull(scale)) {
                scale = 4;
            }
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            byte[] cb = content.getBytes(charater);
            int lineWidth = size;
            int width = 0;
            boolean[][] s = qrcodeHandler.calQrcode(cb);
            for (int j = 0; j < s.length; ++j) {
                if (!s[j][0]) continue;
                width = j * lineWidth + border;
            }
            BufferedImage bi = new BufferedImage(width += border + lineWidth, width, 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.setBackground(back);
            g2d.clearRect(0, 0, width, width);
            g2d.setColor(front);
            for (int i = 0; i < s.length; ++i) {
                for (int j = 0; j < s.length; ++j) {
                    if (!s[j][i]) continue;
                    g2d.fillRect(j * lineWidth + border, i * lineWidth + border, lineWidth, lineWidth);
                }
            }
            g2d.dispose();
            bi.flush();
            if (!this.isNull(logoPath) && this.isNull(animtePath)) {
                File inputFile = new File(logoPath);
                BufferedImage logo = ImageIO.read(inputFile);
                bi = this.modifyImagetogeter(logo, bi, scale);
            }
            if (!this.isNull(logoPath) && !this.isNull(animtePath)) {
                File inputFile = new File(logoPath);
                BufferedImage logo = ImageIO.read(inputFile);
                this.generateGif(logo, bi, animtePath, scale);
            } else {
                File imgFile = new File(imgPath);
                ImageIO.write((RenderedImage)bi, imgType, imgFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String encoderQRCode(QRCode qrCode) throws IOException {
        if (this.isNull(qrCode.getContent())) {
            qrCode.setContent("\u6211\u662f\u4e8c\u7ef4\u7801\u7684\u5185\u5bb9");
        }
        if (this.isNull(qrCode.getImgPath())) {
            qrCode.setImgPath("c:\\test.jpg");
        }
        if (this.isNull(qrCode.getImgType())) {
            qrCode.setImgType("png");
        }
        if (this.isNull(qrCode.getCharater())) {
            qrCode.setCharater("UTF-8");
        }
        if (this.isNull(qrCode.getSize())) {
            qrCode.setSize(4);
        }
        if (this.isNull(qrCode.getBorder())) {
            qrCode.setBorder(20);
        }
        if (this.isNull(qrCode.getFront())) {
            qrCode.setFront(Color.BLACK);
        }
        if (this.isNull(qrCode.getBack())) {
            qrCode.setBack(Color.WHITE);
        }
        if (this.isNull(qrCode.getScale())) {
            qrCode.setScale(4);
        }
        Qrcode qrcodeHandler = new Qrcode();
        qrcodeHandler.setQrcodeErrorCorrect('M');
        qrcodeHandler.setQrcodeEncodeMode('B');
        byte[] cb = qrCode.getContent().getBytes(qrCode.getCharater());
        int lineWidth = qrCode.getSize();
        int width = 0;
        boolean[][] s = qrcodeHandler.calQrcode(cb);
        for (int j = 0; j < s.length; ++j) {
            if (!s[j][0]) continue;
            width = j * lineWidth + qrCode.getBorder();
        }
        BufferedImage bi = new BufferedImage(width += qrCode.getBorder() + lineWidth, width, 1);
        Graphics2D g2d = bi.createGraphics();
        g2d.setBackground(qrCode.getBack());
        g2d.clearRect(0, 0, width, width);
        g2d.setColor(qrCode.getFront());
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < s.length; ++j) {
                if (!s[j][i]) continue;
                if (qrCode.getDotChange() != null && qrCode.getDotChange() == 2) {
                    if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                        g2d.setColor(Color.BLUE);
                    } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                        g2d.setColor(Color.GREEN);
                    } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                        g2d.setColor(Color.RED);
                    } else {
                        g2d.setColor(qrCode.getFront());
                    }
                } else if (qrCode.getDotChange() != null && qrCode.getDotChange() == 3) {
                    if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                        g2d.setColor(Color.GREEN);
                    } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                        g2d.setColor(Color.RED);
                    } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                        g2d.setColor(Color.BLUE);
                    } else {
                        g2d.setColor(qrCode.getFront());
                    }
                } else if (qrCode.getDotChange() != null) {
                    if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                        g2d.setColor(Color.RED);
                    } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                        g2d.setColor(Color.BLUE);
                    } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                        g2d.setColor(Color.GREEN);
                    } else {
                        g2d.setColor(qrCode.getFront());
                    }
                }
                g2d.fillRect(j * lineWidth + qrCode.getBorder(), i * lineWidth + qrCode.getBorder(), lineWidth, lineWidth);
            }
        }
        if (!this.isNull(qrCode.getTopText())) {
            int strWidth = g2d.getFontMetrics().stringWidth(qrCode.getTopText());
            g2d.drawString(qrCode.getTopText(), Math.abs(strWidth - width) / 2, qrCode.getBorder() / 2 + 5);
        }
        if (!this.isNull(qrCode.getDownText())) {
            g2d.setFont(new Font("\u5b8b\u4f53", 0, 12));
            g2d.drawString(qrCode.getDownText(), (width - qrCode.getDownText().length() * 6) / 2, bi.getHeight() - qrCode.getBorder() / 2 + 5);
        }
        g2d.dispose();
        bi.flush();
        if (!this.isNull(qrCode.getLogoPath())) {
            ClassPathResource resource = new ClassPathResource(qrCode.getLogoPath());
            InputStream inputFile = resource.getInputStream();
            BufferedImage logo = ImageIO.read(inputFile);
            bi = this.modifyImagetogeter(logo, bi, qrCode.getScale());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, qrCode.getImgType(), out);
        byte[] bytes = out.toByteArray();
        BASE64Encoder base64Encoder = new BASE64Encoder();
        String binary = base64Encoder.encode(bytes).trim();
        return "data:image/png;base64," + binary;
    }

    public void encoderQRCode(String content, String imgPath, String imgType, String charater, Integer size, Integer border, Color front, Color back, Integer scale, String logoPath, String topText, String downText, Color dotColor, String backFile) {
        try {
            File bkfile;
            if (this.isNull(content)) {
                content = "test";
            }
            if (this.isNull(imgPath)) {
                imgPath = "c:/test.png";
            }
            if (this.isNull(imgType)) {
                imgType = "png";
            }
            if (this.isNull(charater)) {
                charater = "UTF-8";
            }
            if (this.isNull(size)) {
                size = 4;
            }
            if (this.isNull(border)) {
                border = size * 2;
            }
            if (this.isNull(front)) {
                front = Color.BLACK;
            }
            if (this.isNull(back)) {
                back = Color.WHITE;
            }
            if (this.isNull(scale)) {
                scale = 5;
            }
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            byte[] cb = content.getBytes(charater);
            int lineWidth = size;
            int width = 0;
            boolean[][] s = qrcodeHandler.calQrcode(cb);
            for (int j = 0; j < s.length; ++j) {
                if (!s[j][0]) continue;
                width = j * lineWidth + border;
            }
            BufferedImage bi = new BufferedImage(width += border + lineWidth, width, 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.setBackground(back);
            g2d.clearRect(0, 0, width, width);
            BufferedImage bk = null;
            BufferedImage buf = null;
            if (!this.isNull(backFile) && (bk = ImageIO.read(bkfile = new File(backFile))) != null) {
                buf = new BufferedImage(width, width, 1);
                buf.getGraphics().drawImage(bk, 0, 0, width, width, null);
            }
            for (int i = 0; i < s.length; ++i) {
                for (int j = 0; j < s.length; ++j) {
                    if (!s[j][i]) continue;
                    int x = j * lineWidth + border;
                    int y = i * lineWidth + border;
                    if (buf != null) {
                        int[] rgb = new int[3];
                        int pixel = buf.getRGB(x, y);
                        rgb[0] = (pixel & 0xFF0000) >> 16;
                        rgb[1] = (pixel & 0xFF00) >> 8;
                        rgb[2] = pixel & 0xFF;
                        front = new Color(rgb[0], rgb[1], rgb[2]);
                    }
                    if (dotColor != null) {
                        if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                            g2d.setColor(dotColor);
                        } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                            g2d.setColor(dotColor);
                        } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                            g2d.setColor(dotColor);
                        } else {
                            g2d.setColor(front);
                        }
                    } else {
                        g2d.setColor(front);
                    }
                    g2d.fillRect(x, y, lineWidth, lineWidth);
                }
            }
            if (!this.isNull(topText)) {
                g2d.drawString(topText, (width - topText.length() * 12) / 2, border / 2 + 5);
            }
            if (!this.isNull(downText)) {
                g2d.setFont(new Font("\u5b8b\u4f53", 0, 12));
                g2d.drawString(downText, (width - downText.length() * 6) / 2, bi.getHeight() - border / 2 + 5);
            }
            g2d.dispose();
            bi.flush();
            if (!this.isNull(logoPath)) {
                File inputFile = new File(logoPath);
                BufferedImage logo = ImageIO.read(inputFile);
                bi = this.modifyImagetogeter(logo, bi, scale);
            }
            File imgFile = new File(imgPath);
            ImageIO.write((RenderedImage)bi, imgType, imgFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean encoderQRCode(String content, String imgPath, String imgType, String charater, Integer size, Color front, Color back, Color dotColor, BufferedImage backFile, String regStr, Integer isCheck, Integer rount) {
        try {
            if (this.isNull(content)) {
                content = "test";
            }
            if (this.isNull(imgPath)) {
                imgPath = "c:\test.png";
            }
            if (this.isNull(imgType)) {
                imgType = "png";
            }
            if (this.isNull(charater)) {
                charater = "UTF-8";
            }
            if (this.isNull(size)) {
                size = 4;
            }
            if (this.isNull(front)) {
                front = Color.BLACK;
            }
            if (this.isNull(dotColor)) {
                dotColor = front;
            }
            if (this.isNull(back)) {
                back = Color.WHITE;
            }
            if (this.isNull(regStr)) {
                regStr = "^http://(\\w*\\.){2,4}(\\w*\\:*\\d*/){1}([a-z]*/){3,4}\\d{1,}$";
            }
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            int border = size * 2;
            byte[] cb = content.getBytes(charater);
            int lineWidth = size;
            int width = 0;
            boolean[][] s = qrcodeHandler.calQrcode(cb);
            for (int j = 0; j < s.length; ++j) {
                if (!s[j][0]) continue;
                width = j * lineWidth + border;
            }
            BufferedImage bi = new BufferedImage(width += border + lineWidth, width, 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.setBackground(back);
            g2d.clearRect(0, 0, width, width);
            BufferedImage buf = null;
            if (!this.isNull(backFile)) {
                buf = new BufferedImage(width, width, 1);
                buf.getGraphics().drawImage(backFile, 0, 0, width, width, null);
                g2d.drawImage(buf, 0, 0, width, width, Color.WHITE, null);
            }
            for (int i = 0; i < s.length; ++i) {
                for (int j = 0; j < s.length; ++j) {
                    if (!s[j][i]) continue;
                    int x = j * lineWidth + border;
                    int y = i * lineWidth + border;
                    if (i >= 0 && i <= 6 && j >= 0 && j <= 6) {
                        g2d.setComposite(AlphaComposite.SrcOver.derive(0.75f));
                        g2d.setColor(dotColor);
                        g2d.fillRect(x, y, lineWidth, lineWidth);
                        g2d.setColor(Color.WHITE);
                        if (j == 0) {
                            g2d.fillRect(x - lineWidth, y, lineWidth, lineWidth);
                            if (i < 5) {
                                g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (i == 0) {
                            g2d.fillRect(x - lineWidth, y - lineWidth, lineWidth, lineWidth);
                            if (j == 6) {
                                g2d.fillRect(x, y - lineWidth, lineWidth, lineWidth);
                            }
                            if (j > 0 && j < 5) {
                                g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (i == 6) {
                            g2d.fillRect(x - lineWidth, y + lineWidth, lineWidth, lineWidth);
                            if (j == 6) {
                                g2d.fillRect(x, y + lineWidth, lineWidth, lineWidth);
                            }
                            if (j > 0 && j < 5) {
                                g2d.fillRect(x + lineWidth, y - lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (j != 6) continue;
                        g2d.fillRect(x + lineWidth, y - lineWidth, lineWidth, lineWidth);
                        if (i == 6) {
                            g2d.fillRect(x + lineWidth, y, lineWidth, lineWidth);
                            g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                        }
                        if (i <= 0 || i >= 4) continue;
                        g2d.fillRect(x - lineWidth, y + lineWidth, lineWidth, lineWidth);
                        continue;
                    }
                    if (i >= 0 && i <= 6 && j >= s.length - 7 && j <= s.length - 1) {
                        g2d.setComposite(AlphaComposite.SrcOver.derive(0.75f));
                        g2d.setColor(dotColor);
                        g2d.fillRect(x, y, lineWidth, lineWidth);
                        g2d.setColor(Color.WHITE);
                        if (j == s.length - 7) {
                            g2d.fillRect(x - lineWidth, y, lineWidth, lineWidth);
                            if (i < 5) {
                                g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (i == 0) {
                            g2d.fillRect(x - lineWidth, y - lineWidth, lineWidth, lineWidth);
                            if (j == s.length - 1) {
                                g2d.fillRect(x, y - lineWidth, lineWidth, lineWidth);
                            }
                            if (j > s.length - 7 && j < s.length - 2) {
                                g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (i == 6) {
                            g2d.fillRect(x - lineWidth, y + lineWidth, lineWidth, lineWidth);
                            if (j == s.length - 1) {
                                g2d.fillRect(x, y + lineWidth, lineWidth, lineWidth);
                            }
                            if (j > s.length - 7 && j < s.length - 2) {
                                g2d.fillRect(x + lineWidth, y - lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (j != s.length - 1) continue;
                        g2d.fillRect(x + lineWidth, y - lineWidth, lineWidth, lineWidth);
                        if (i == 6) {
                            g2d.fillRect(x + lineWidth, y, lineWidth, lineWidth);
                            g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                        }
                        if (i <= 0 || i >= 4) continue;
                        g2d.fillRect(x - lineWidth, y + lineWidth, lineWidth, lineWidth);
                        continue;
                    }
                    if (i >= s.length - 7 && i <= s.length - 1 && j >= 0 && j <= 6) {
                        g2d.setComposite(AlphaComposite.SrcOver.derive(0.75f));
                        g2d.setColor(dotColor);
                        g2d.fillRect(x, y, lineWidth, lineWidth);
                        g2d.setColor(Color.WHITE);
                        if (j == 0) {
                            g2d.fillRect(x - lineWidth, y, lineWidth, lineWidth);
                            if (i < s.length - 2) {
                                g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (i == s.length - 7) {
                            g2d.fillRect(x - lineWidth, y - lineWidth, lineWidth, lineWidth);
                            if (j == 6) {
                                g2d.fillRect(x, y - lineWidth, lineWidth, lineWidth);
                            }
                            if (j > 0 && j < 5) {
                                g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (i == s.length - 1) {
                            g2d.fillRect(x - lineWidth, y + lineWidth, lineWidth, lineWidth);
                            if (j == 6) {
                                g2d.fillRect(x, y + lineWidth, lineWidth, lineWidth);
                            }
                            if (j > 0 && j < 5) {
                                g2d.fillRect(x + lineWidth, y - lineWidth, lineWidth, lineWidth);
                            }
                        }
                        if (j != 6) continue;
                        g2d.fillRect(x + lineWidth, y - lineWidth, lineWidth, lineWidth);
                        if (i == s.length - 1) {
                            g2d.fillRect(x + lineWidth, y, lineWidth, lineWidth);
                            g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth, lineWidth);
                        }
                        if (i <= s.length - 7 || i >= s.length - 2) continue;
                        g2d.fillRect(x - lineWidth, y + lineWidth, lineWidth, lineWidth);
                        continue;
                    }
                    if (!this.isNull(rount) && rount == 1) {
                        g2d.setColor(front);
                        g2d.setComposite(AlphaComposite.SrcOver.derive(0.8f));
                        g2d.fillRoundRect(x, y, lineWidth * 2 / 3, lineWidth * 2 / 3, lineWidth * 1 / 3, lineWidth * 1 / 3);
                        g2d.setColor(Color.WHITE);
                        g2d.fillRoundRect(x + lineWidth, y, lineWidth * 2 / 3, lineWidth * 2 / 3, lineWidth * 1 / 3, lineWidth * 1 / 3);
                        g2d.fillRoundRect(x, y + lineWidth, lineWidth * 2 / 3, lineWidth * 2 / 3, lineWidth * 1 / 3, lineWidth * 1 / 3);
                        g2d.fillRoundRect(x + lineWidth, y + lineWidth, lineWidth * 2 / 3, lineWidth * 2 / 3, lineWidth * 1 / 3, lineWidth * 1 / 3);
                        continue;
                    }
                    g2d.setColor(front);
                    g2d.setComposite(AlphaComposite.SrcOver.derive(0.8f));
                    g2d.fillRect(x, y, lineWidth * 2 / 3, lineWidth * 2 / 3);
                    g2d.setColor(Color.WHITE);
                    g2d.fillRect(x + lineWidth, y, lineWidth * 2 / 3, lineWidth * 2 / 3);
                    g2d.fillRect(x, y + lineWidth, lineWidth * 2 / 3, lineWidth * 2 / 3);
                    g2d.fillRect(x + lineWidth, y + lineWidth, lineWidth * 2 / 3, lineWidth * 2 / 3);
                }
            }
            g2d.dispose();
            bi.flush();
            if (!this.isNull(isCheck) && isCheck == 1 && !this.checkCode(bi, regStr)) {
                return false;
            }
            File imgFile = new File(imgPath);
            ImageIO.write((RenderedImage)bi, imgType, imgFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void encoderQRCode(String content, String imgPath, String imgType, String charater, Integer size, Integer border, Color front, Color back, Integer scale, String logoPath, String topText, String downText, Integer dotChange, Integer codeVersion) {
        try {
            if (this.isNull(content)) {
                content = "test";
            }
            if (this.isNull(imgPath)) {
                imgPath = "c:\test.png";
            }
            if (this.isNull(imgType)) {
                imgType = "png";
            }
            if (this.isNull(charater)) {
                charater = "UTF-8";
            }
            if (this.isNull(size)) {
                size = 4;
            }
            if (this.isNull(border)) {
                border = 20;
            }
            if (this.isNull(front)) {
                front = Color.BLACK;
            }
            if (this.isNull(back)) {
                back = Color.WHITE;
            }
            if (this.isNull(scale)) {
                scale = 4;
            }
            if (this.isNull(codeVersion)) {
                codeVersion = 3;
            }
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('M');
            qrcodeHandler.setQrcodeEncodeMode('B');
            qrcodeHandler.setQrcodeVersion(codeVersion.intValue());
            byte[] cb = content.getBytes(charater);
            int lineWidth = size;
            int width = 0;
            boolean[][] s = qrcodeHandler.calQrcode(cb);
            for (int j = 0; j < s.length; ++j) {
                if (!s[j][0]) continue;
                width = j * lineWidth + border;
            }
            BufferedImage bi = new BufferedImage(width += border + lineWidth, width, 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.setBackground(back);
            g2d.clearRect(0, 0, width, width);
            g2d.setColor(front);
            for (int i = 0; i < s.length; ++i) {
                for (int j = 0; j < s.length; ++j) {
                    if (!s[j][i]) continue;
                    if (dotChange != null && dotChange == 2) {
                        if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                            g2d.setColor(Color.BLUE);
                        } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                            g2d.setColor(Color.GREEN);
                        } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                            g2d.setColor(Color.RED);
                        } else {
                            g2d.setColor(front);
                        }
                    } else if (dotChange != null && dotChange == 3) {
                        if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                            g2d.setColor(Color.GREEN);
                        } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                            g2d.setColor(Color.RED);
                        } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                            g2d.setColor(Color.BLUE);
                        } else {
                            g2d.setColor(front);
                        }
                    } else if (dotChange != null) {
                        if (i >= 2 && i <= 4 && j >= 2 && j <= 4) {
                            g2d.setColor(Color.RED);
                        } else if (i >= 2 && i <= 4 && j >= s.length - 5 && j <= s.length - 3) {
                            g2d.setColor(Color.BLUE);
                        } else if (i >= s.length - 5 && i <= s.length - 3 && j >= 2 && j <= 4) {
                            g2d.setColor(Color.GREEN);
                        } else {
                            g2d.setColor(front);
                        }
                    }
                    g2d.fillRect(j * lineWidth + border, i * lineWidth + border, lineWidth, lineWidth);
                }
            }
            if (!this.isNull(topText)) {
                g2d.drawString(topText, (width - topText.length() * 12) / 2, border / 2 + 5);
            }
            if (!this.isNull(downText)) {
                g2d.setFont(new Font("\u5b8b\u4f53", 0, 12));
                g2d.drawString(downText, (width - downText.length() * 8) / 2, bi.getHeight() - border / 2 + 5);
            }
            g2d.dispose();
            bi.flush();
            if (!this.isNull(logoPath)) {
                File inputFile = new File(logoPath);
                BufferedImage logo = ImageIO.read(inputFile);
                bi = this.modifyImagetogeter(logo, bi, scale);
            }
            File imgFile = new File(imgPath);
            ImageIO.write((RenderedImage)bi, imgType, imgFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage modifyImagetogeter(BufferedImage logo, BufferedImage code, Integer scale) {
        BufferedImage buf = new BufferedImage(code.getWidth(), code.getHeight(), 1);
        try {
            int h = code.getHeight() / scale;
            int w = logo.getWidth() * h / logo.getHeight();
            Graphics2D g = buf.createGraphics();
            g.drawImage(code, 0, 0, code.getWidth(), code.getHeight(), null);
            g.drawImage(logo, (code.getWidth() - w) / 2, (code.getHeight() - h) / 2, w, h, null);
            g.dispose();
            buf.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf;
    }

    public void generateGif(BufferedImage logo, BufferedImage code, String animtePath, Integer scale) {
        try {
            BufferedImage src0 = this.modifyImagetogeter(logo, code, scale);
            BufferedImage src1 = this.modifyImagetogeter(logo, code, scale / 2);
            BufferedImage src2 = this.modifyImagetogeter(logo, code, scale / 4);
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.start(animtePath);
            e.setDelay(300);
            e.addFrame(src0);
            e.setDelay(300);
            e.addFrame(src1);
            e.setDelay(300);
            e.addFrame(src2);
            e.finish();
        }
        catch (Exception er) {
            er.printStackTrace();
        }
    }

    public boolean isNull(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            if (((String)value).trim().replaceAll("\\s", "").equals("")) {
                return true;
            }
        } else if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return true;
            }
        } else if (value.getClass().isArray()) {
            if (Array.getLength(value) == 0) {
                return true;
            }
        } else if (value instanceof Map) {
            if (((Map)value).isEmpty()) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public boolean checkCode(BufferedImage bi, String regStr) {
        if (this.isNull(regStr)) {
            regStr = "^http://(\\w*\\.){2,4}(\\w*\\:*\\d*/){1}([a-z]*/){3,4}\\d{1,}$";
        }
        try {
            QRCodeDecoder decoder = new QRCodeDecoder();
            String decodedData = new String(decoder.decode((QRCodeImage)new J2SEImage(bi)));
            if (this.isNull(decodedData)) {
                return false;
            }
            if (decodedData.length() > 0 && !Pattern.matches(regStr, decodedData)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String deCode(BufferedImage bi) {
        String decodedData = null;
        try {
            QRCodeDecoder decoder = new QRCodeDecoder();
            decodedData = new String(decoder.decode((QRCodeImage)new J2SEImage(bi)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decodedData;
    }

    class J2SEImage
    implements QRCodeImage {
        BufferedImage bufImg;

        public J2SEImage(BufferedImage bufImg) {
            this.bufImg = bufImg;
        }

        public int getWidth() {
            return this.bufImg.getWidth();
        }

        public int getHeight() {
            return this.bufImg.getHeight();
        }

        public int getPixel(int x, int y) {
            return this.bufImg.getRGB(x, y);
        }
    }
}

