package com.biz.crm.business.common.base.eunm;

import java.util.Objects;

/**
 * 流程状态枚举
 *
 * @author jerry7
 */
public enum ProcessStatusEnum {
    START("0", "0", "发起流程", "0"),
    PREPARE("1", "1", "待提交", "1"),
    COMMIT("2", "2", "审批中", "2"),
    PASS("3", "3", "审批通过", "3"),
    REJECT("4", "4", "驳回", "4"),
    RECOVER("5", "5", "追回", "5"),
    COLSE("6", "6", "关闭", "6");
    /**
     * 系统key
     */
    private String key;
    /**
     * 字典编码
     */
    private String dictCode;
    /**
     * 字典值
     */
    private String value;
    /**
     * 字典排序
     */
    private String order;

    ProcessStatusEnum(String key, String dictCode, String value, String order) {
        this.key = key;
        this.dictCode = dictCode;
        this.value = value;
        this.order = order;
    }

    /**
     * 根据编码返回流程状态名称
     *
     * @param key
     * @return
     */
    public static String getStatusNameByKey(String key) {
        if (Objects.nonNull(key)) {
            ProcessStatusEnum[] values = ProcessStatusEnum.values();
            for (ProcessStatusEnum statusEnum : values) {
                if (statusEnum.getKey().equals(key)) {
                    return statusEnum.getValue();
                }
            }
        }
        return null;
    }

    /**
     * 根据编码校验状态值是否存在
     *
     * @param key
     * @return
     */
    public static boolean checkKeyExist(String key) {

        ProcessStatusEnum[] values = ProcessStatusEnum.values();
        for (ProcessStatusEnum statusEnum : values) {
            if (statusEnum.getKey().equals(key)) {
                return true;
            }
        }
        return false;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDictCode() {
        return dictCode;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}
