package com.biz.crm.business.common.base.login.refresh;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 这是倒数第二个用户刷新的工作策略，设置当前登录人
 *
 * @author yinwenjie
 */
@Component
public class CurrLoginUserRefreshStrategy implements AuthenticationRefreshStrategy {


    @Override
    public int getOrder() {
        //倒数第二个工作
        return Integer.MAX_VALUE - 1;
    }

    @Override
    public boolean matched(Object info) {
        if (Objects.isNull(info)) {
            return false;
        }
        return info instanceof FacturerUserDetails;
    }

    @Override
    public UserIdentity refresh(Object userInfo) {
        return (FacturerUserDetails) userInfo;
    }

}
