package com.biz.crm.business.common.base.util;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @Description 异常信息
 * @Author YangWei
 * @Date 2023/3/23 上午9:42
 */
@Slf4j
public class ExceptionStackMsgUtil {

    /**
     * 获取异常信息
     *
     * @param e
     * @return
     */
    public static String stackMsg(Exception e) {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            // 将出错的栈信息输出到printWriter中
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        } finally {
            if (sw != null) {
                try {
                    sw.close();
                } catch (IOException ex) {
                    log.error("异常打印异常:stackMsg", ex);
                    log.error(ex.getMessage(), ex);
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

}