package com.biz.crm.business.common.base.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.base.eunm.ProcessStatusEnum;
import com.biz.crm.business.common.base.eunm.ProcessTypeEnum;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.ibatis.type.JdbcType;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.Date;

/**
 * @className: com.biz.crm.business.common.base.entity.CrmJdbProcessEntity
 * @description: JDB业务审批基础类
 * @author: xiaopeng.zhang
 * @create: 2025-02-15 14:10
 */
@MappedSuperclass
@Data
public abstract class CrmJdbProcessEntity extends TenantFlagOpEntity {


    /**
     * 审批业务编码
     * 继承后由各个业务模块自行定义前缀等编码规则
     */
    @ApiModelProperty("审批业务编码")
    @TableField(value = "process_code", jdbcType = JdbcType.VARCHAR)
    @Column(name = "process_code", length = 64, columnDefinition = "VARCHAR2(64)")
    private String processCode;

    /**
     * 审批状态
     *
     * @see ProcessStatusEnum
     */
    @ApiModelProperty("审批状态")
    @TableField(value = "process_status")
    @Column(name = "process_status", length = 16, columnDefinition = "VARCHAR2(16)")
    private String processStatus;

    /**
     * 审批状态
     *
     * @see ProcessTypeEnum
     */
    @ApiModelProperty("审批类型")
    @TableField(value = "process_type")
    @Column(name = "process_type", length = 16, columnDefinition = "VARCHAR2(16)")
    private String processType;

    /**
     * 业务编码 各个审批审批的唯一标识 用于联查回显数据，更新等
     */
    @ApiModelProperty("业务编码")
    @TableField(value = "business_code")
    @Column(name = "business_code", length = 64, columnDefinition = "VARCHAR2(64)")
    private String businessCode;

//    申请人相关消息
    /**
     * 申请人用户名
     */
    @Column(name = "apply_user_name", length = 32, columnDefinition = "VARCHAR2(32)")
    @ApiModelProperty("用户名")
    private String applyUserName;

    /**
     * 申请人人员姓名
     */
    @Column(name = "apply_real_name", length = 128, columnDefinition = "VARCHAR2(128)")
    @ApiModelProperty("人员姓名")
    private String applyRealName;

    /**
     * 申请人职位编码
     */
    @Column(name = "apply_position_code", length = 32, columnDefinition = "VARCHAR2(32)")
    @ApiModelProperty("职位编码")
    private String applyPositionCode;
    /**
     * 申请人职位名称
     */
    @Column(name = "apply_position_name", length = 128, columnDefinition = "VARCHAR2(128)")
    @ApiModelProperty("职位名称")
    private String applyPositionName;

    /**
     * 申请人组织编码
     */
    @Column(name = "apply_org_code", length = 32, columnDefinition = "VARCHAR2(32)")
    @ApiModelProperty("组织编码")
    private String applyOrgCode;

    /**
     * 申请人组织名称
     */
    @Column(name = "apply_org_name", length = 128, columnDefinition = "VARCHAR2(128)")
    @ApiModelProperty("组织名称")
    private String applyOrgName;

    /**
     * 申请时间
     */
    @ApiModelProperty("申请时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "apply_time", length = 20, columnDefinition = "DATE")
    private Date applyTime;

    //    审批人相关消息
    /**
     * 审批人用户名
     */
    @Column(name = "approval_user_name", length = 32, columnDefinition = "VARCHAR2(32)")
    @ApiModelProperty("用户名")
    private String approvalUserName;

    /**
     * 审批人人员姓名
     */
    @Column(name = "approval_real_name", length = 128, columnDefinition = "VARCHAR2(128)")
    @ApiModelProperty("人员姓名")
    private String approvalRealName;

    /**
     * 审批人职位编码
     */
    @Column(name = "approval_position_code", length = 32, columnDefinition = "VARCHAR2(32)")
    @ApiModelProperty("职位编码")
    private String approvalPositionCode;
    /**
     * 审批人职位名称
     */
    @Column(name = "approval_position_name", length = 128, columnDefinition = "VARCHAR2(128)")
    @ApiModelProperty("职位名称")
    private String approvalPositionName;

    /**
     * 审批人组织编码
     */
    @Column(name = "approval_org_code", length = 32, columnDefinition = "VARCHAR2(32)")
    @ApiModelProperty("组织编码")
    private String approvalOrgCode;

    /**
     * 审批人组织名称
     */
    @Column(name = "approval_org_name", length = 128, columnDefinition = "VARCHAR2(128)")
    @ApiModelProperty("组织名称")
    private String approvalOrgName;

    /**
     * 审批人时间
     */
    @ApiModelProperty("审批人时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "approval_time", length = 20, columnDefinition = "DATE")
    private Date approvalTime;


    /**
     * 审批待更新数据 超长的话这儿在加加
     */
    @ApiModelProperty("审批待更新数据")
    @Column(name = "process_data", columnDefinition = "NCLOB")
    private String processData;

    /**
     * 更改项 审批前后的差异集合JSON 用于前端回显更改项 超长的话这儿在加加
     */
    @ApiModelProperty("更改项")
    @Column(name = "change_list", columnDefinition = "NCLOB")
    private String changeList;


    /**
     * 审批备注 文本框备注
     */
    @ApiModelProperty("审批备注")
    @Column(name = "process_remark", columnDefinition = "VARCHAR2(400)")
    private String processRemark;

}
