package com.biz.crm.business.common.base.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 验证数据有效性
 *
 * @author 肖胜
 * @version v1.0
 */
public class ValidateUtil {

    //非法字符
    public static final String NAME = "[`~!@#$%^&* +=|{}':;',\\[\\].<>/?~！@#￥%……&*——+|{}【】‘；：’。，、？]";

    //数字与字母
    public static final String ERPCODE = "[a-z0-9A-Z]";

    //数字字母及中文
    public static final String Correct = "^[a-zA-Z0-9\u4e00-\u9fa5]+$";

    /**
     * 验证是否有非法字符
     *
     * @param str
     * @return
     */
    public static boolean validateName(String str, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.find();
    }

    /**
     * 验证是否符合表达式
     *
     * @param str
     * @param regex
     * @return
     */
    public static boolean regExp(String str, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}
