package com.biz.crm.business.common.base.eunm;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @className: com.biz.crm.business.common.base.eunm.ProcessTypeEnum
 * @description: 审批业务类型枚举
 * @author: xiaopeng.zhang
 * @create: 2025-02-15 14:21
 */
@Getter
@AllArgsConstructor
public enum ProcessTypeEnum {

    TERMINAL_SIGN("terminal_sign", "terminal_sign", "渠道合伙人签约", "0"),
    TERMINAL_CHANGE("terminal_change", "terminal_change", "门店变更", "1"),
    TERMINAL_DISABLE("terminal_disable", "terminal_disable", "门店禁用", "2"),
    TERMINAL_BAR_CODE("terminal_bar_code", "terminal_bar_code", "门店条码变更", "3");

    /**
     * 系统key
     */
    private String key;
    /**
     * 字典编码
     */
    private String dictCode;
    /**
     * 字典值
     */
    private String value;
    /**
     * 字典排序
     */
    private String order;
}
