package com.biz.crm.business.common.base.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 批量保存
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2024/5/9 16:39
 */
public interface BusinessBaseMapper<T> extends BaseMapper<T> {


    /**
     * 全字段更新，不会忽略null值
     *
     * @param entity 实体对象
     * @return
     * @author huxmld
     * @version v1.0.0
     * @date 2024/5/9 16:35
     */
    int alwaysUpdateSomeColumnById(@Param("et") T entity);

    /**
     * 全量插入,等价于insert
     *
     * @param entityList
     * @return
     * @author huxmld
     * @version v1.0.0
     * @date 2024/5/9 16:35
     */
    int insertBatchSomeColumn(List<T> entityList);

}