/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.base.vo.RuleSplitVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyEditorSupport;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DateUtil
extends PropertyEditorSupport {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final SimpleDateFormat date_yyyy = new SimpleDateFormat("yyyy");
    public static final SimpleDateFormat date_yyyy_MM = new SimpleDateFormat("yyyy-MM");
    public static final SimpleDateFormat date_yy_MM = new SimpleDateFormat("yy-MM");
    public static final SimpleDateFormat date_yyyyMM = new SimpleDateFormat("yyyyMM");
    public static final SimpleDateFormat date_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat date_yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat date_HH_mm = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat date_HH_mm_ss = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat date_HH_mm_ss_SSS = new SimpleDateFormat("HH:mm:ss SSS");
    public static final SimpleDateFormat date_yyyy_MM_dd_HH = new SimpleDateFormat("yyyy-MM-dd HH");
    public static final SimpleDateFormat date_yyyy_MM_dd_HH_mm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat date_yyyy_MM_dd_HH_mm_ss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat date_yyyyMMddHHmmss = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat date_yyyy_MM_dd_HH_mm_ss_SSS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    public static final SimpleDateFormat date_str_yyyy = new SimpleDateFormat("yyyy\u5e74");
    public static final SimpleDateFormat date_str_yyyy_MM = new SimpleDateFormat("yyyy\u5e74MM\u6708");
    public static final SimpleDateFormat date_str_yyyy_MM_dd = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static final SimpleDateFormat date_str_yyyy_MM_dd_HH_mm_ss_SSS = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
    public static final long MINUTE_IN_SECOND = 60L;
    public static final long HOUR_IN_SECOND = 3600L;
    public static final long DAY_IN_SECOND = 86400L;
    public static final int MINIMAL_DAYS_IN_FIRST_WEEK = 4;
    public static final int FIRST_DAY_OF_WEEK = 2;
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final String DEFAULT_YEAR_MONTH = "yyyy-MM";
    public static final String DEFAULT_YEAR_MONTH_NO_CH = "yyyyMM";
    public static final String DEFAULT_YEAR_MONTH_PATTERN = "yyyy\u5e74MM\u6708";
    public static final String DEFAULT_YEAR_MONTH_DAY = "yyyy-MM-dd";
    public static final String DEFAULT_YEAR_MONTH_DAY_NO_CH = "yyyyMMdd";
    public static final String DEFAULT_DAY = "dd";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm";
    public static final String DEFAULT_TIME_ALL_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyyMMddHHmmss";
    public static final String DEFAULT_DATE_ALL_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String MAX_END_TIME = "9999-12-31 23:59:59";
    public static final String DAY_EARLIEST_TIME = " 00:00:00";
    public static final String DAY_LATEST_TIME = " 23:59:59";
    static int[] DAYS = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static String dateStrNowYYYYMMDD() {
        return new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY).format(new java.util.Date());
    }

    public static String dateStrNowYYYYMM() {
        return new SimpleDateFormat(DEFAULT_YEAR_MONTH).format(new java.util.Date());
    }

    public static String dateStrYYYYMMDD(java.util.Date date) {
        return new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY).format(date);
    }

    public static java.util.Date dateYYYYMMDD(String date) {
        try {
            return new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY).parse(date);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String dateStrNowAll() {
        return DateUtil.dateToStr(new SimpleDateFormat(DEFAULT_DATE_ALL_PATTERN));
    }

    public static String dateStrNowHms() {
        return DateUtil.dateToStr(date_HH_mm_ss);
    }

    public static String dateToStr(SimpleDateFormat dateSdf) {
        return DateUtil.dateToStr(dateSdf, new java.util.Date());
    }

    public static String dateToStr(SimpleDateFormat dateSdf, java.util.Date date) {
        return dateSdf.format(date);
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static String getFormatDateStr(java.util.Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(pattern, Locale.US);
        return dtFmt.format(date);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new java.util.Date(millis));
        return cal;
    }

    public static String timestampToStr(Timestamp time) {
        java.util.Date date = null;
        if (null != time) {
            date = new java.util.Date(time.getTime());
        }
        return DateUtil.dateToStr(date_yyyy_MM_dd, date);
    }

    public static Timestamp strToTimestamp(String str) {
        java.util.Date date = DateUtil.strToDate(str, date_yyyy_MM_dd);
        return new Timestamp(date.getTime());
    }

    public static java.util.Date strToDate(String dateStr, SimpleDateFormat sdf) {
        if (null == sdf || null == dateStr || "".equals(dateStr)) {
            return null;
        }
        java.util.Date date = null;
        try {
            date = sdf.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getMonthSpace(String date1, String date2, String format) {
        int result = 0;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(sdf.parse(date1));
            c2.setTime(sdf.parse(date2));
            result = (c1.get(1) - c2.get(1)) * 12 + c1.get(2) - c2.get(2);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result == 0 ? 1 : Math.abs(result);
    }

    public static String dateStrFormat(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        java.util.Date _date = null;
        try {
            _date = sdf.parse(date);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return sdf.format(_date);
    }

    public static String dateToStr(java.util.Date date, SimpleDateFormat date_sdf) {
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String getDate(String format) {
        return new SimpleDateFormat(format).format(new java.util.Date());
    }

    public static java.util.Date getDate(SimpleDateFormat format) {
        try {
            String nowDate = format.format(new java.util.Date());
            return format.parse(nowDate);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getTimestamp(String time) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(new java.util.Date().getTime());
    }

    public static Timestamp getTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp getCalendarTimestamp(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static String formatDate() {
        return new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY).format(DateUtil.getCalendar().getTime());
    }

    public static String getDataString(SimpleDateFormat formatstr) {
        return formatstr.format(DateUtil.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal) {
        return date_yyyy_MM_dd.format(cal.getTime());
    }

    public static String formatDate(java.util.Date date) {
        return date_yyyy_MM_dd.format(date);
    }

    public static String formatDate(long millis) {
        return date_yyyy_MM_dd.format(new java.util.Date(millis));
    }

    public static String formatDate(String pattern) {
        return DateUtil.getSimpleDateFormat(pattern).format(DateUtil.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal, String pattern) {
        return DateUtil.getSimpleDateFormat(pattern).format(cal.getTime());
    }

    public static String formatDate(java.util.Date date, String pattern) {
        return DateUtil.getSimpleDateFormat(pattern).format(date);
    }

    public static String formatTime() {
        return date_yyyy_MM_dd_HH_mm.format(DateUtil.getCalendar().getTime());
    }

    public static String formatTime(long millis) {
        return date_yyyy_MM_dd_HH_mm.format(new java.util.Date(millis));
    }

    public static String formatTime(Calendar cal) {
        return date_yyyy_MM_dd_HH_mm.format(cal.getTime());
    }

    public static String formatTime(java.util.Date date) {
        return date_yyyy_MM_dd_HH_mm.format(date);
    }

    public static String formatShortTime() {
        return new SimpleDateFormat(DEFAULT_TIME_ALL_PATTERN).format(DateUtil.getCalendar().getTime());
    }

    public static String formatShortTime(long millis) {
        return date_HH_mm_ss.format(new java.util.Date(millis));
    }

    public static String formatShortTime(Calendar cal) {
        return date_HH_mm_ss.format(cal.getTime());
    }

    public static String formatShortTime(java.util.Date date) {
        return date_HH_mm_ss.format(date);
    }

    public static java.util.Date parseDate(String src, String pattern) {
        try {
            return DateUtil.getSimpleDateFormat(pattern).parse(src);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)src, (Object)pattern);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Calendar parseCalendar(String src, String pattern) {
        java.util.Date date = DateUtil.parseDate(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String formatAddDate(String src, String pattern, int amount) {
        Calendar cal = DateUtil.parseCalendar(src, pattern);
        cal.add(5, amount);
        return DateUtil.formatDate(cal);
    }

    public static String formatCurrAddDate(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, amount);
        return DateUtil.formatDate(cal);
    }

    public static String formatAddMonth(String src, String pattern, int month) {
        Calendar cal = DateUtil.parseCalendar(src, pattern);
        cal.add(2, month);
        return DateUtil.formatDate(cal);
    }

    public static String formatAddMonthYearMonth(String src, int month) {
        Calendar cal = DateUtil.parseCalendar(src, DEFAULT_YEAR_MONTH_DAY);
        cal.add(2, month);
        return date_yyyy_MM.format(cal.getTime());
    }

    public static java.util.Date formatAddMonth(java.util.Date src, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static java.util.Date formatAddYear(java.util.Date src, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        calendar.add(1, year);
        return calendar.getTime();
    }

    public static Timestamp parseTimestamp(String src, String pattern) {
        java.util.Date date = DateUtil.parseDate(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static int dateDiff(char flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = calSrc.getTimeInMillis() - calDes.getTimeInMillis();
        if (flag == 'y') {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == 'd') {
            return (int)(millisDiff / 86400000L);
        }
        if (flag == 'h') {
            return (int)(millisDiff / 3600000L);
        }
        if (flag == 'm') {
            return (int)(millisDiff / 60000L);
        }
        if (flag == 's') {
            return (int)(millisDiff / 1000L);
        }
        return 0;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text != null && !"".equals(text)) {
            try {
                if (!text.contains(":") && text.length() == 10) {
                    this.setValue(date_yyyy_MM_dd.parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == 19) {
                    this.setValue(date_yyyy_MM_dd_HH_mm_ss.parse(text));
                }
                throw new IllegalArgumentException("Could not parse date, date format is error ");
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getCurrentYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new java.util.Date());
        return calendar.get(1);
    }

    public static int getCurrentMonth() {
        return DateUtil.getPostCurrentMonth() + 1;
    }

    public static int getPostCurrentMonth() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new java.util.Date());
        return calendar.get(2);
    }

    public static long subtractDay(java.util.Date endDate, java.util.Date startDate) {
        return (endDate.getTime() - startDate.getTime()) / 86400000L;
    }

    public static java.util.Date ReturnTheDay(java.util.Date date, int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        return calendar.getTime();
    }

    public static String format(java.util.Date date, String pattern) {
        if (date != null) {
            try {
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception e) {
                log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)date, (Object)pattern);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    public static String format(Object value, String pattern) {
        if (value != null) {
            try {
                java.util.Date date = null;
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception e) {
                log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", value, (Object)pattern);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    public static java.util.Date getDateTime(String dateTime) {
        java.util.Date date = new java.util.Date();
        String datePart = DateUtil.format(date, DEFAULT_YEAR_MONTH_DAY);
        String dateTimePart = datePart + " " + dateTime;
        java.util.Date newDate = DateUtil.parse(dateTimePart, DEFAULT_DATE_PATTERN);
        return newDate;
    }

    public static java.util.Date parse(String date, String pattern) {
        java.util.Date newDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            newDate = sdf.parse(date);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)date, (Object)pattern);
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a" + date + "\uff0c\u8f6c\u6362\u4e3a\uff1a" + pattern);
        }
        return newDate;
    }

    public static java.util.Date getYesterdayByDate(String date, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            java.util.Date temp = sdf.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.add(5, -1);
            return cal.getTime();
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)date, (Object)pattern);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, 1);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfQuarter(int year, int quarter) {
        int firstMonth;
        Calendar cal = Calendar.getInstance();
        int days = 0;
        for (int i = firstMonth = (quarter - 1) * 3; i < firstMonth + 3; ++i) {
            cal.set(year, i, 1);
            days += cal.getActualMaximum(5);
        }
        return days;
    }

    public static int getDaysOfYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 0, 1);
        return cal.getActualMaximum(6);
    }

    public static int getDaysOfYear(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(6);
    }

    public static java.util.Date getFirstDayOfWeek(int year, int week) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(year, 0, 1);
        int addDays = week * 7;
        if (cal.get(3) == 1) {
            addDays = (week - 1) * 7;
        }
        cal.add(5, addDays);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfWeek(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)(2 - dayOfWeek) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfLastMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfNextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfNextMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfNextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)(cal.getActualMaximum(5) - 1) * 86400000L);
        return cal.getTime();
    }

    public static int getWeekOfDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.get(3);
    }

    public static int getDayOfDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.get(6);
    }

    public static java.util.Date getDate2() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date yesterday() {
        return new java.util.Date(System.currentTimeMillis() - 86400000L);
    }

    public static java.util.Date tomorrow() {
        return new java.util.Date(System.currentTimeMillis() + 86400000L);
    }

    public static java.util.Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2099);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date parseToDate(Object value) {
        if (value instanceof Timestamp) {
            return (java.util.Date)value;
        }
        if (value instanceof Date) {
            return (java.util.Date)value;
        }
        return (java.util.Date)value;
    }

    public static java.util.Date getAppointDate(int calendarConstant, int appointNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.add(calendarConstant, appointNum);
        return calendar.getTime();
    }

    public static String calSpendTimes(String startTime, String endTime) {
        java.util.Date startTimeDateType = DateUtil.parse(startTime, DEFAULT_DATE_ALL_PATTERN);
        java.util.Date endTimeDateType = null;
        if (endTime != null) {
            endTimeDateType = DateUtil.parse(endTime, DEFAULT_DATE_ALL_PATTERN);
        }
        long totalTimes = endTime == null ? Calendar.getInstance().getTimeInMillis() - startTimeDateType.getTime() : endTimeDateType.getTime() - startTimeDateType.getTime();
        long dayCount = totalTimes / 86400000L;
        long restTimes = totalTimes % 86400000L;
        long hourCount = restTimes / 3600000L;
        long minuteCount = (restTimes %= 3600000L) / 60000L;
        String spendTimes = dayCount + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206\u949f";
        return spendTimes;
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_YEAR_MONTH);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
            Calendar curr = min;
            while (curr.before(max)) {
                result.add(sdf.format(curr.getTime()));
                curr.add(2, 1);
            }
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)minDate, (Object)maxDate);
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Map<Integer, List<Integer>> getDateBetweenMap(String minDate, String maxDate) {
        HashMap map = Maps.newHashMap();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_YEAR_MONTH);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
            Calendar curr = min;
            while (curr.before(max)) {
                int year = curr.get(1);
                List months = (List)map.get(year);
                if (CollectionUtil.isEmpty((Collection)months)) {
                    months = Lists.newArrayList();
                }
                int month = curr.get(2);
                months.add(month + 1);
                map.put(year, months);
                curr.add(2, 1);
            }
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)minDate, (Object)maxDate);
            log.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static boolean isValidDateTime(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(5, 7));
            if (month <= 0 || month > 12) {
                return false;
            }
            int day = Integer.parseInt(date.substring(8, 10));
            if (day <= 0 || day > DAYS[month]) {
                return false;
            }
            if (month == 2 && day == 29 && DateUtil.isGregorianLeapYear(year)) {
                return false;
            }
            int hour = Integer.parseInt(date.substring(11, 13));
            if (hour < 0 || hour > 23) {
                return false;
            }
            int minute = Integer.parseInt(date.substring(14, 16));
            if (minute < 0 || minute > 59) {
                return false;
            }
            int second = Integer.parseInt(date.substring(17, 19));
            if (second < 0 || second > 59) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}]", (Object)date);
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isValidMoth(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(5, 7));
            if (month <= 0 || month > 12) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}]", (Object)date);
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isValidDateNotLine(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(4, 6));
            if (month <= 0 || month > 12) {
                return false;
            }
            int day = Integer.parseInt(date.substring(6, 8));
            if (day <= 0 || day > DAYS[month]) {
                return false;
            }
            if (month == 2 && day == 29 && DateUtil.isGregorianLeapYear(year)) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}]", (Object)date);
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isValidDate(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(5, 7));
            if (month <= 0 || month > 12) {
                return false;
            }
            int day = Integer.parseInt(date.substring(8, 10));
            if (day <= 0 || day > DAYS[month]) {
                return false;
            }
            if (month == 2 && day == 29 && DateUtil.isGregorianLeapYear(year)) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}]", (Object)date);
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isGregorianLeapYear(int year) {
        return year % 4 != 0 || year % 100 == 0 && year % 400 != 0;
    }

    public static java.util.Date switchDate(java.util.Date fromDate, int type) {
        if (fromDate != null) {
            if (type == 0) {
                GregorianCalendar gcLast = (GregorianCalendar)Calendar.getInstance();
                gcLast.setTime(fromDate);
                gcLast.set(11, 0);
                gcLast.set(12, 0);
                gcLast.set(13, 0);
                gcLast.set(5, 1);
                return gcLast.getTime();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fromDate);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar.getTime();
        }
        return null;
    }

    public static String getAnyDay(String dateStr, int addYear, int addMonth, int addDate, int ymd) throws Exception {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            java.util.Date sourceDate = sdf.parse(dateStr);
            SimpleDateFormat sdf_ = new SimpleDateFormat(DEFAULT_YEAR_MONTH);
            java.util.Date sourceDate_ = sdf_.parse(dateStr);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTime(sourceDate);
            cal.add(1, addYear);
            cal.add(2, sourceDate_.getMonth() + addMonth);
            if (ymd == 1) {
                cal.add(5, 0);
            } else if (ymd == 2) {
                cal.set(6, 1);
            } else if (ymd == 3) {
                cal.set(5, cal.getActualMaximum(5));
                System.out.println(cal.getTime().getMonth());
            } else {
                cal.set(1, cal.getTime().getYear() + 1900);
                cal.set(6, cal.getActualMaximum(6));
            }
            cal.add(5, addDate);
            SimpleDateFormat returnSdf = new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY);
            String dateTmp = returnSdf.format(cal.getTime());
            return dateTmp;
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}]", (Object)dateStr);
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public static String getFirstDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_YEAR_MONTH);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(date));
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f[{}]", (Object)date);
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        calendar.set(5, calendar.getMinimum(5));
        SimpleDateFormat format2 = new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY);
        return format2.format(calendar.getTime());
    }

    public static String getFinalDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_YEAR_MONTH);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(date));
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f[{}]", (Object)date);
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        calendar.set(5, calendar.getActualMaximum(5));
        SimpleDateFormat format2 = new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY);
        return format2.format(calendar.getTime());
    }

    public static boolean isDate(String aDate) {
        return DateUtil.isDate(aDate, DEFAULT_YEAR_MONTH_DAY);
    }

    public static boolean isDate(String aDate, String fmt) {
        if (aDate == null || "".equals(aDate.trim())) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        sdf.setLenient(false);
        try {
            sdf.parse(aDate);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)aDate, (Object)fmt);
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getAnyDay(String dateStr, String pattern, int addYear, int addMonth, int addDay) {
        try {
            java.util.Date date = DateUtil.parseDate(dateStr, pattern);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (addYear != 0) {
                cal.add(1, addYear);
            }
            if (addMonth != 0) {
                cal.add(2, addMonth);
            }
            if (addDay != 0) {
                cal.add(5, addDay);
            }
            return DateUtil.formatDate(cal);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38", (Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String filterChar(String date) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(date);
        return m.replaceAll("");
    }

    public static int getDayOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String convertDateStr(long millSec) {
        SimpleDateFormat fmtDateTime = new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY);
        return fmtDateTime.format(new java.util.Date(millSec * 1000L));
    }

    public static java.util.Date extractionDate(long millSec) {
        java.util.Date in = new java.util.Date(millSec * 1000L);
        SimpleDateFormat fmtDateTime = new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY);
        String text = fmtDateTime.format(in);
        ParsePosition pos = new ParsePosition(0);
        return ((DateFormat)fmtDateTime).parse(text, pos);
    }

    public static int[] monthToYear(int month) {
        int[] ret = new int[]{0, 0};
        ret[0] = month / 12;
        if (month % 12 != 0) {
            ret[1] = month % 12;
        }
        return ret;
    }

    public static String monthToYearStr(int month) {
        int[] ret = DateUtil.monthToYear(month);
        String str = ret[0] + "\u5c81";
        if (ret[0] <= 5 && ret[1] != 0) {
            str = str + ret[1] + "\u4e2a\u6708";
        }
        return str;
    }

    public static String getDateStrByFormat(java.util.Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        return dtFmt.format(date);
    }

    public static boolean isSameDate(java.util.Date date1, java.util.Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static boolean isSameDay(java.util.Date date1, java.util.Date date2) {
        long between = Math.abs(date2.getTime() - date1.getTime());
        if (between > 86400000L) {
            return false;
        }
        if (between == 86400000L) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            if (cal1.get(11) == 0 && cal2.get(11) == 0) {
                return true;
            }
            if (cal1.get(11) == 24) {
                cal2.get(11);
            }
            return false;
        }
        return true;
    }

    public static java.util.Date getDateByFormat(String date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        java.util.Date dateTime = null;
        try {
            dateTime = dtFmt.parse(date);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5904\u7406\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return dateTime;
    }

    public static long getDistanceDay(long date1, long date2) {
        long newDate2;
        String dateStr1 = DateUtil.getDateStrByFormat(new java.util.Date(date1 * 1000L), DEFAULT_YEAR_MONTH_DAY);
        String dateStr2 = DateUtil.getDateStrByFormat(new java.util.Date(date2 * 1000L), DEFAULT_YEAR_MONTH_DAY);
        java.util.Date date3 = DateUtil.getDateByFormat(dateStr1, DEFAULT_YEAR_MONTH_DAY);
        java.util.Date date4 = DateUtil.getDateByFormat(dateStr2, DEFAULT_YEAR_MONTH_DAY);
        long newDate1 = DateUtil.convertTimeStamp(date3);
        long diff = newDate1 >= (newDate2 = DateUtil.convertTimeStamp(date4)) ? newDate1 - newDate2 : newDate2 - newDate1;
        return diff / 86400L;
    }

    public static long convertTimeStamp(java.util.Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime() / 1000L;
    }

    public static int getDistanceSecond(long date1, long date2) {
        long diff = date1 - date2;
        double diffDouble = Math.ceil(1.0 * (double)diff / 1000.0);
        return (int)diffDouble;
    }

    public static Integer getAge(java.util.Date birthday) {
        if (birthday == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int yearNow = calendar.get(1);
        calendar.setTime(birthday);
        int yearBirth = calendar.get(1);
        if (yearNow - yearBirth < 0) {
            return null;
        }
        return yearNow - yearBirth;
    }

    public static int getDayCount(java.util.Date startDate, java.util.Date endDate) {
        if (!startDate.before(endDate)) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(endDate);
        return (int)((calendar1.getTimeInMillis() - calendar.getTimeInMillis()) / 86400000L);
    }

    public static int getDistanceMonth(java.util.Date start, java.util.Date end) {
        if (start.after(end)) {
            java.util.Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(5, 1);
        int year = endCalendar.get(1) - startCalendar.get(1);
        int month = endCalendar.get(2) - startCalendar.get(2);
        if (startCalendar.get(5) == 1 && temp.get(5) == 1) {
            return year * 12 + month + 1;
        }
        if (startCalendar.get(5) != 1 && temp.get(5) == 1) {
            return year * 12 + month;
        }
        if (startCalendar.get(5) == 1 && temp.get(5) != 1) {
            return year * 12 + month;
        }
        return year * 12 + month - 1 < 0 ? 0 : year * 12 + month;
    }

    public static String getWeekDayStr(Integer weekDay) {
        String str = "\u5468";
        switch (weekDay) {
            case 1: {
                str = str + "\u4e00";
                break;
            }
            case 2: {
                str = str + "\u4e8c";
                break;
            }
            case 3: {
                str = str + "\u4e09";
                break;
            }
            case 4: {
                str = str + "\u56db";
                break;
            }
            case 5: {
                str = str + "\u4e94";
                break;
            }
            case 6: {
                str = str + "\u516d";
                break;
            }
            case 7: {
                str = str + "\u65e5";
            }
        }
        return str;
    }

    public static String getDayTypeStr(Integer dayType) {
        String str = "";
        switch (dayType) {
            case 1: {
                str = str + "\u4e0a\u5348";
                break;
            }
            case 2: {
                str = str + "\u4e0b\u5348";
                break;
            }
            case 3: {
                str = str + "\u665a\u4e0a";
            }
        }
        return str;
    }

    public static boolean isToday(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        int startDayCount = (int)calendar.getTimeInMillis() / 86400000;
        calendar.setTime(date);
        int endDayCount = (int)calendar.getTimeInMillis() / 86400000;
        return endDayCount == startDayCount;
    }

    public static java.util.Date getDayByDateDistance(java.util.Date date, int distanceDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, distanceDay);
        java.util.Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static java.util.Date getTimeByTimeAndDiffSecond(java.util.Date date, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, second);
        return calendar.getTime();
    }

    public static boolean isOverlap(java.util.Date dt1Start, java.util.Date dt1End, java.util.Date dt2Start, java.util.Date dt2End) {
        if (dt1Start == null || dt1End == null || dt2Start == null || dt2End == null) {
            throw new IllegalArgumentException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        long dt1StartLong = dt1Start.getTime();
        long dt1EndLong = dt1End.getTime();
        long dt2StartLong = dt2Start.getTime();
        long dt2EndLong = dt2End.getTime();
        if (dt1StartLong >= dt1EndLong) {
            throw new IllegalArgumentException("param error,param1 must before param2");
        }
        if (dt2StartLong >= dt2EndLong) {
            throw new IllegalArgumentException("param error,param3 must before param4");
        }
        if (dt1EndLong <= dt2StartLong) {
            return false;
        }
        return dt1StartLong < dt2EndLong;
    }

    public static boolean isDateBetween(java.util.Date start, java.util.Date end, java.util.Date paramDate) {
        if (start == null || end == null || paramDate == null) {
            throw new IllegalArgumentException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        long startLong = start.getTime();
        long endLong = end.getTime();
        long paramLong = paramDate.getTime();
        return startLong <= paramLong && paramLong <= endLong;
    }

    public static java.util.Date getTodayStartTime(java.util.Date date) {
        if (date == null) {
            date = new java.util.Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static java.util.Date getTodayEndTime(java.util.Date date) {
        if (date == null) {
            date = new java.util.Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static long dateToTimeStamp(String dateStr, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr).getTime() / 1000L;
        }
        catch (Exception e) {
            log.error("\u65e5\u671f[{}],\u683c\u5f0f[{}]", (Object)dateStr, (Object)format);
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static int getQuarterByMonth(int month) {
        int quarter = 4;
        if (month >= 1 && month <= 3) {
            quarter = 1;
        } else if (month >= 4 && month <= 6) {
            quarter = 2;
        } else if (month >= 7 && month <= 9) {
            quarter = 3;
        }
        return quarter;
    }

    public static java.util.Date localDateTimeConvertToDate(LocalDateTime localDateTime) {
        return java.util.Date.from(localDateTime.toInstant(ZoneOffset.of("+8")));
    }

    public static LocalDateTime dateConvertToLocalDateTime(java.util.Date date) {
        return date.toInstant().atOffset(ZoneOffset.of("+8")).toLocalDateTime();
    }

    public static String getWeek(String date) {
        return DateUtil.getWeek(date, DEFAULT_YEAR_MONTH_DAY);
    }

    public static String getWeek(String dateStr, String format) {
        if (StringUtils.isEmpty((CharSequence)dateStr) || StringUtils.isEmpty((CharSequence)format)) {
            return "";
        }
        try {
            Calendar cal = Calendar.getInstance();
            java.util.Date date = new SimpleDateFormat(format).parse(dateStr);
            cal.setTime(date);
            int w = cal.get(7) - 1;
            if (w == 0) {
                w = 7;
            }
            return String.valueOf(w);
        }
        catch (Exception e) {
            log.error("dates[{}]", (Object)dateStr);
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static java.util.Date dateAddSecond(java.util.Date date, int second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, second);
        return cal.getTime();
    }

    public static java.util.Date dateAddMinute(java.util.Date date, Integer num) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, num);
        return c.getTime();
    }

    public static java.util.Date dateAddHour(java.util.Date date, Integer num) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, num);
        return c.getTime();
    }

    public static java.util.Date dateAddDay(java.util.Date date, Integer num) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, num);
        return c.getTime();
    }

    public static java.util.Date dateAddMonth(java.util.Date date, Integer month) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(2, month);
        return rightNow.getTime();
    }

    public static Boolean judgeDateStrBetween(String dateStr, String beginDate, String endDate) {
        String substring = dateStr.substring(0, 7);
        String substring1 = beginDate.substring(0, 7);
        String substring2 = endDate.substring(0, 7);
        return substring.compareTo(substring1) >= 0 && substring.compareTo(substring2) <= 0;
    }

    public static String secondsToStr(Long seconds) {
        if (seconds == null) {
            return "";
        }
        return DateUtil.millisecondToStr(seconds * 1000L);
    }

    public static String millisecondToStr(long millisecond) {
        long days = millisecond / 86400000L;
        long hours = millisecond % 86400000L / 3600000L;
        long minute = millisecond % 86400000L % 3600000L / 60000L;
        long second = millisecond % 86400000L % 3600000L % 60000L / 1000L;
        long millisecondStr = millisecond % 86400000L % 3600000L % 60000L % 1000L;
        String spendTimes = "";
        if (days > 0L) {
            spendTimes = spendTimes + days + "\u5929";
        }
        if (hours > 0L) {
            spendTimes = spendTimes + hours + "\u5c0f\u65f6";
        }
        if (minute > 0L) {
            spendTimes = spendTimes + minute + "\u5206\u949f";
        }
        if (second > 0L) {
            spendTimes = spendTimes + second + "\u79d2";
        }
        if (millisecondStr > 0L) {
            spendTimes = spendTimes + millisecondStr + "\u6beb\u79d2";
        }
        return spendTimes;
    }

    public static String secondsToStrVague(Long seconds) {
        if (seconds == null) {
            return "";
        }
        return DateUtil.millisecondToStrVague(seconds * 1000L);
    }

    public static String millisecondToStrVague(long millisecond) {
        long days = millisecond / 86400000L;
        long hours = millisecond % 86400000L / 3600000L;
        long minute = millisecond % 86400000L % 3600000L / 60000L;
        long second = millisecond % 86400000L % 3600000L % 60000L / 1000L;
        long millisecondStr = millisecond % 86400000L % 3600000L % 60000L % 1000L;
        String spendTimes = "";
        if (days > 0L) {
            spendTimes = spendTimes + days + "\u5929";
        }
        if (hours > 0L) {
            spendTimes = spendTimes + hours + "\u5c0f\u65f6";
        }
        if (minute > 0L) {
            spendTimes = spendTimes + minute + "\u5206\u949f";
        }
        if (StringUtils.isEmpty((CharSequence)spendTimes) && second > 0L) {
            spendTimes = spendTimes + second + "\u79d2";
        }
        if (StringUtils.isEmpty((CharSequence)spendTimes) && millisecondStr > 0L) {
            spendTimes = spendTimes + millisecondStr + "\u6beb\u79d2";
        }
        return spendTimes;
    }

    public static List<String> getBetweenDays(java.util.Date startTime, java.util.Date endTime) {
        return DateUtil.getBetweenDays(startTime, endTime, DEFAULT_YEAR_MONTH_DAY);
    }

    public static List<String> getBetweenDays(java.util.Date startTime, java.util.Date endTime, String format) {
        LinkedList<String> days = new LinkedList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(startTime);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(endTime);
        tempEnd.add(5, 1);
        while (tempStart.before(tempEnd)) {
            days.add(dateFormat.format(tempStart.getTime()));
            tempStart.add(6, 1);
        }
        return days;
    }

    public static List<String> getBetweenYearMonths(java.util.Date startTime, java.util.Date endTime, String format) {
        LinkedList<String> days = new LinkedList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(startTime);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(endTime);
        while (tempStart.before(tempEnd)) {
            days.add(dateFormat.format(tempStart.getTime()));
            tempStart.add(2, 1);
            tempStart.set(5, 1);
        }
        return days;
    }

    public static String transToDateString(String date, String format) {
        if (date.length() == 8) {
            return DateUtil.getFormatDateStr(DateUtil.getDateByFormat(date, DEFAULT_YEAR_MONTH_DAY_NO_CH), format);
        }
        if (date.length() == 10) {
            if (date.contains("-")) {
                return DateUtil.getFormatDateStr(DateUtil.getDateByFormat(date, DEFAULT_YEAR_MONTH_DAY), format);
            }
            if (date.contains("/")) {
                return DateUtil.getFormatDateStr(DateUtil.getDateByFormat(date, "yyyy/MM/dd"), format);
            }
        }
        return null;
    }

    public static java.util.Date localDate2Date(LocalDate localDate) {
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant1 = zonedDateTime.toInstant();
        java.util.Date from = java.util.Date.from(instant1);
        return from;
    }

    public static void main(String[] args) {
        System.out.println(date_yyyy_MM_dd_HH_mm_ss.format(DateUtil.dateAddSecond(new java.util.Date(), 120)));
        System.out.println(date_yyyy_MM_dd_HH_mm_ss.format(DateUtil.dateAddMinute(new java.util.Date(), 5)));
        System.out.println(date_yyyy_MM_dd_HH_mm_ss.format(DateUtil.dateAddHour(new java.util.Date(), 1)));
        System.out.println(date_yyyy_MM_dd_HH_mm_ss.format(DateUtil.dateAddDay(new java.util.Date(), 1)));
        System.out.println(date_yyyy_MM_dd_HH_mm_ss.format(DateUtil.dateAddMonth(new java.util.Date(), 1)));
    }

    public static List<RuleSplitVo> splitForTable02(String begin, String end) {
        ArrayList<RuleSplitVo> list = new ArrayList<RuleSplitVo>();
        DateUtil.dealSplit(list, begin, end);
        return list;
    }

    private static void dealSplit(List<RuleSplitVo> list, String begin, String end) {
        begin = DateUtil.dealDate00(begin);
        end = DateUtil.dealDate00(end);
        RuleSplitVo temp = new RuleSplitVo();
        String begin_end = DateUtil.getMaxMonthDate(begin, 0, 2);
        temp.setBegin(begin);
        if (begin_end.compareTo(end) >= 0) {
            temp.setEnd(end);
            list.add(temp);
        } else {
            temp.setEnd(begin_end);
            list.add(temp);
            String nextFirst = DateUtil.getMaxMonthDate(begin, 1, 1);
            DateUtil.dealSplit(list, nextFirst, end);
        }
    }

    private static String dealDate00(String datestr) {
        if (StringUtils.isNotBlank((CharSequence)datestr) && datestr.substring(0, 2).equals("00")) {
            datestr = "20" + datestr.substring(2);
        }
        return datestr;
    }

    public static String getMaxMonthDate(String dateStr, int month, int type) {
        dateStr = DateUtil.dealDate00(dateStr);
        SimpleDateFormat dft = null;
        Calendar calendar = null;
        dft = new SimpleDateFormat(DEFAULT_YEAR_MONTH_DAY_NO_CH);
        java.util.Date date = DateUtil.parseDate(dateStr, DEFAULT_YEAR_MONTH_DAY_NO_CH);
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, month);
        if (type == 1) {
            calendar.set(5, calendar.getActualMinimum(5));
        } else {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return dft.format(calendar.getTime());
    }
}

