package com.biz.crm.business.common.base.util;

import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName DataTooLongGenerateRespUtil
 * @Description
 * @author jiangyin
 * @Date 2023/6/16
 */
@Slf4j
public class DataTooLongExceptionUtil {

    private static final Pattern PATTERN = Pattern.compile("Data too long for column '.*'");

    public static String generateRespStr(Exception e, Class<?> entityClass) {
        if (entityClass == null) {
            return e.getMessage();
        }
        Matcher matcher = PATTERN.matcher(e.getMessage());
        if (matcher.find()) {
            String columnName = matcher.group(0).replace("Data too long for column ", "").replaceAll("'", "").toLowerCase();
            if (StringUtils.isEmpty(columnName)) {
                return e.getMessage();
            }
            try {
                Field[] fields = entityClass.getDeclaredFields();
                //考虑字段名不一定对应到属性的驼峰命名，只能考虑遍历全部字段
                for (Field field : fields) {
                    Annotation[] annotations = field.getDeclaredAnnotations();
                    ApiModelProperty apiModelProperty = null;
                    for (Annotation annotation : annotations) {
                        if (annotation instanceof ApiModelProperty) {
                            apiModelProperty = (ApiModelProperty) annotation;
                        }
                    }
                    for (Annotation annotation : annotations) {
                        if (annotation instanceof Column) {
                            Column column = (Column) annotation;
                            if (columnName.equals(column.name())) {
                                //获取ApiModelProperty注解的中文字段名
                                if (apiModelProperty != null) {
                                    if (StringUtils.isNotEmpty((apiModelProperty.value()))) {
                                        return "字段【" + apiModelProperty.value() + "】长度过长，最大长度限制为" + column.length();
                                    } else if (StringUtils.isNotEmpty((apiModelProperty.name()))) {
                                        return "字段【" + apiModelProperty.name() + "】长度过长，最大长度限制为" + column.length();
                                    }
                                } else {
                                    return "字段【" + column.columnDefinition().toLowerCase()
                                            .replaceAll("'", "")
                                            .replaceAll("comment", "") + "】长度过长，最大长度限制为" + column.length();
                                }
                            }
                        }
                    }
                }
            } catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            return e.getMessage();
        }
        return e.getMessage();
    }


}
