package com.biz.crm.business.common.base.util;

import net.coobird.thumbnailator.Thumbnails;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * @Description
 * @Author lifei
 * @Date 2025/6/4 17:12
 **/
public class ImageCompressor {

    public static byte[] compressToMax30KB(byte[] originalImageBytes) {
        if (originalImageBytes == null || originalImageBytes.length == 0) {
            throw new IllegalArgumentException("原始图片字节为空");
        }

        final int maxSize = 30 * 1024;
        double quality = 1.0;
        int width = 500, height = 500;
        byte[] result = originalImageBytes;

        BufferedImage bufferedImage;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(originalImageBytes)) {
            bufferedImage = ImageIO.read(bais);
        } catch (IOException e) {
            throw new RuntimeException("读取图片失败", e);
        }

        for (int attempt = 0; attempt < 20; attempt++) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {
                Thumbnails.of(bufferedImage)
                        .size(width, height)
                        .outputQuality(quality)
                        .outputFormat("jpg")
                        .toOutputStream(outputStream);

                byte[] compressed = outputStream.toByteArray();
                if (compressed.length <= maxSize) {
                    result = compressed;
                    break;
                }

                if (quality > 0.1) {
                    quality -= 0.1;
                } else {
                    width *= 0.9;
                    height *= 0.9;
                }

            } catch (IOException e) {
                throw new RuntimeException("压缩图片失败", e);
            }
        }

        return result;
    }
}
