package com.biz.crm.business.common.base.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.base.vo.TkSapReturnItemVo;
import com.biz.crm.business.common.base.vo.TkSapReturnVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by idea on 2018/8/29
 */
public class JsonStringParseUtil {

    /**
     * 将返回的json字符串解析成TkSapReturnVo
     *
     * @param json
     * @return
     */
    public static TkSapReturnVo parseJsonToTkSapReturnVo(String json) {
        TkSapReturnVo vo = new TkSapReturnVo();

        try {
            JSONObject jsonObject = JSONObject.parseObject(json);
            JSONArray itable = jsonObject.getJSONArray("ITABLE");
            JSONObject itable1 = itable.getJSONObject(0);
            List<String> gzMessages = new ArrayList<>();
            //判断状态
            Object mtype = itable1.get("MTYPE");
            if (mtype != null && mtype.equals("S")) {
                //成功
                vo.setMessage(itable1.get("MSSAG").toString());
            } else {
                //失败
                String message = itable1.get("MSSAG").toString();
                List<String> messages = new ArrayList<>();
                JSONArray item = itable1.getJSONArray("ITEM");
                for (int i = 0; i < item.size(); i++) {
                    JSONObject itemObj = item.getJSONObject(i);
                    String itemMsg = itemObj.get("MSSAG").toString();
                    if (!"S".equals(itemObj.get("MTYPE"))&& StringUtils.isNotEmpty(itemMsg)) {
                        messages.add("SAP行项目"+itemObj.get("BATPO")+itemObj.get("MSSAG").toString());
                    }

                    //过账标记不为C
                    if(!"C".equals(itemObj.get("WBSTK"))){
                        String matnr = "";
                        if(itemObj.get("MATNR")!=null){
                            matnr = (String) itemObj.get("MATNR");
                            if(StringUtils.isNotEmpty(matnr)){
                                gzMessages.add("物料:"+matnr+"过账失败");
                                vo.setGzFlag(false);
                            }
                        }

                    }

                }
                if (CollectionUtils.isNotEmpty(messages)) {
                    message += "," + StringUtils.join(messages.toArray(), ",");
                }

                if(CollectionUtils.isNotEmpty(gzMessages)){
                    String gzMessage = "," + StringUtils.join(gzMessages.toArray(), ",");
                    vo.setGzMessage(gzMessage);
                }
                if ("W".equals(mtype)) {
                    //警告
                    vo.setWarn(true);
                } else {
                    //失败
                    vo.setSuccess(false);
                }
                vo.setMessage(message);
            }

            //解析返回集合
            List<TkSapReturnItemVo> list = JSONArray.parseArray(itable1.getString("ITEM"), TkSapReturnItemVo.class);
            vo.setItems(list);

        } catch (Exception e) {
            e.printStackTrace();
            vo.setSuccess(false);
            vo.setMessage("返回JSON解析错误");
        }
        return vo;
    }

}
