package com.biz.crm.business.common.base.util;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/3/6 21:48
 */
@Slf4j
public class BusinessBeanUtils {

    public static <T> List<T> mapListToBeanList(List<Map<String,Object>> mapList,Class<T> cls,boolean throwException){
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(cls);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors)
                .collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        List<T> list = Lists.newArrayList();
        for (Map<String, Object> objectMap : mapList) {
            T t = null;
            try {
                t = cls.newInstance();
                list.add(t);
            } catch (Exception e) {
                log.error(e.getMessage(),e);
                if (throwException) {
                    throw new RuntimeException("实例" + cls + "初始化失败");
                }
                continue;
            }
            for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                if (null == entry.getValue()){
                    continue;
                }
                PropertyDescriptor propertyDescriptor = propertyMap.get(entry.getKey());
                if (null == propertyDescriptor){
                    continue;
                }

                try {
                    //转换一下字段类型
                    Object value = entry.getValue();
                    if ((BigDecimal.class == propertyDescriptor.getPropertyType())){
                        value = new BigDecimal(value.toString());
                    }else if(Integer.class == propertyDescriptor.getPropertyType()){
                        value = Integer.parseInt(value.toString());
                    }
                    propertyDescriptor.getWriteMethod().invoke(t,value);
                } catch (Exception e) {
                    log.error(e.getMessage(),e);
                    if (throwException){
                        throw new RuntimeException("属性["+propertyDescriptor.getName()+"]转换失败："+e.getMessage());
                    }
                }
            }
        }
        return list;
    }

}
