package com.biz.crm.business.common.base.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @Description
 * @Author lifei
 * @Date 2025/4/29 19:53
 **/
@Getter
@Setter
@Configuration
@ConfigurationProperties(prefix = "request")
public class RequestControlProperties {

    private int timeoutSeconds = 60;
    private int idempotentExpireSeconds = 60;

    private final Limit limit = new Limit();

    @Getter
    @Setter
    public static class Limit {
        private boolean enabled = true;
        private String keyPrefix = "api_limit:";
        private int maxCount = 5;
        private int expireSeconds = 60;
    }
}
