package com.biz.crm.business.common.base.util;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description 必填校验 对应模板的校验
 * @Author lifei
 * @Date 2024/7/19 14:09
 */
public class BusinessRequiredUtil {

    private static final Logger log = LoggerFactory.getLogger(BusinessRequiredUtil.class);


    /**
     * 校验必填字段
     *
     * @param filedMap        模板必填字段校验 key=字段编码，value=是否必填
     * @param chineseFiledMap 模板字段map，key=字段编码，value=字段描述
     * @param o               数据源
     */
    public static String filedRequiredCheck(Map<String, Boolean> filedMap, Map<String, String> chineseFiledMap, Object o) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(o.getClass());
        StringJoiner errMsg = new StringJoiner(";");
        Map<String, PropertyDescriptor> map = Arrays.asList(propertyDescriptors).stream().collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        for (Map.Entry<String, PropertyDescriptor> entry : map.entrySet()) {
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (null == propertyDescriptor) {
                continue;
            }
            Object value = null;
            try {
                value = propertyDescriptor.getReadMethod().invoke(o);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            if (filedMap.containsKey(entry.getKey())) {
                if (filedMap.get(entry.getKey())) {
                    if (ObjectUtils.isEmpty(value)) {
                        errMsg.add(String.format("字段%s不能为空,表单模板配置此字段必填", chineseFiledMap.get(entry.getKey())));
                    }
                }
            }
        }
        return errMsg.toString();
    }

}
