package com.biz.crm.business.common.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.base.webservice.ZPI_SERVERS_SOAStub;
import com.biz.crm.business.common.sdk.model.Result;
import org.apache.axis2.Constants;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.impl.httpclient3.HttpTransportPropertiesImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

import java.rmi.RemoteException;

@Component
public class SapUtils {
    private static final Logger log = LoggerFactory.getLogger(SapUtils.class);

    @Value("${sap.newwebserviceclient:}")
    private String newwebserviceclient;

    @Value("${sap.webserviceclient:}")
    private String webserviceclient;

    @Value("${sap.new_sap_username:}")
    private String new_sap_username;

    @Value("${sap.new_sap_password:}")
    private String new_sap_password;

    /**
     * rest调用通用工具类 自定义地址
     *
     * @param jsonstr
     * @return
     * @author xuduan
     */
    public Result restPostcore(JSONObject jsonstr) {
        Result head = new Result();
        try {
            head = shareFromSap(jsonstr);
            log.info("====SapUtils==restPostcore========={}", JSON.toJSONString(head));
            if (StringUtils.isBlank(head.getMessage())) {
                head.setSuccess(false);
                head.setMessage("返回信息为空");
                return head;
            }
            JSONObject obc = JSONObject.parseObject(head.getMessage());
            JSONArray s = obc.getJSONArray("ITABLE");
            if (s != null) {
                Object rt = s.getJSONObject(0).get("MTYPE");
                if (rt != null && rt.equals("E")) {
                    head.setSuccess(false);
                }
            }

        } catch (RestClientException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), e);
        }
        return head;
    }

    public Result restNewPostCore(JSONObject jsonstr) {
        Result head = Result.ok();
        try {
            head = shareFromNewSap(jsonstr);
            log.info("====SapUtils==restPostcore========={}", JSON.toJSONString(head));
            JSONObject obc = JSONObject.parseObject(head.getMessage());
            JSONArray s = obc.getJSONArray("ITABLE");
            if (s != null) {
                Object rt = s.getJSONObject(0).get("MTYPE");
                if (rt != null && rt.equals("E")) {
                    head.setSuccess(false);
                }
            }

        } catch (RestClientException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), e);
        }
        return head;
    }

    private Result shareFromNewSap(JSONObject in_json) {
        Result head = new Result();
        try {
            ZPI_SERVERS_SOAStub stub = new ZPI_SERVERS_SOAStub(newwebserviceclient);
            HttpTransportPropertiesImpl.Authenticator authenticator = new HttpTransportPropertiesImpl.Authenticator();
            authenticator.setUsername(new_sap_username);
            authenticator.setPassword(new_sap_password);
            stub._getServiceClient().getOptions()
                    .setProperty(HTTPConstants.AUTHENTICATE, authenticator);
            stub._getServiceClient().getOptions()
                    .setProperty(Constants.Configuration.CHARACTER_SET_ENCODING, "utf-8");
            //stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(300000);
            stub._getServiceClient().getOptions().setProperty(HTTPConstants.SO_TIMEOUT, new Integer(300000));
            stub._getServiceClient().getOptions().setProperty(HTTPConstants.CONNECTION_TIMEOUT, new Integer(300000));
//					.setTimeOutInMilliSeconds(300 * 1000L);
            stub._getServiceClient().getOptions().setProperty(Constants.Configuration.HTTP_METHOD, HTTPConstants.HTTP_METHOD_POST);
            stub._getServiceClient().getOptions().setProperty(HTTPConstants.HEADER_CONNECTION, HTTPConstants.HEADER_CONNECTION_CLOSE);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC async = new ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC();
            ZPI_SERVERS_SOAStub.String strJson = new ZPI_SERVERS_SOAStub.String();
            strJson.setString(in_json != null ? in_json.toJSONString() : "");
            async.setIN_JSON(strJson);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNCResponse response = stub.zIF_DATA_TO_SAP_SYNC(async);
            head.setSuccess(true);
            head.setMessage(response.getOUT_JSON().toString());
            stub._getServiceClient().cleanupTransport();
            stub._getServiceClient().cleanup();
            stub.cleanup();
            stub = null;
        } catch (RemoteException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), e);
        }
        return head;
    }

    private Result shareFromSap(JSONObject in_json) {
        Result head = new Result();
        try {
//            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((java.lang.String)null, (java.lang.String)null);
            ZPI_SERVERS_SOAStub stub = new ZPI_SERVERS_SOAStub(null, webserviceclient);
            HttpTransportPropertiesImpl.Authenticator authenticator = new HttpTransportPropertiesImpl.Authenticator();
            authenticator.setUsername(new_sap_username);
            authenticator.setPassword(new_sap_password);
            stub._getServiceClient().getOptions()
                    .setProperty(HTTPConstants.AUTHENTICATE, authenticator);
            stub._getServiceClient().getOptions()
                    .setProperty(Constants.Configuration.CHARACTER_SET_ENCODING, "utf-8");
            //stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(300000);
            stub._getServiceClient().getOptions().setProperty(HTTPConstants.SO_TIMEOUT, new Integer(300000));
            stub._getServiceClient().getOptions().setProperty(HTTPConstants.CONNECTION_TIMEOUT, new Integer(300000));
//					.setTimeOutInMilliSeconds(300 * 1000L);
            stub._getServiceClient().getOptions().setProperty(Constants.Configuration.HTTP_METHOD, HTTPConstants.HTTP_METHOD_POST);
            stub._getServiceClient().getOptions().setProperty(HTTPConstants.HEADER_CONNECTION, HTTPConstants.HEADER_CONNECTION_CLOSE);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC async = new ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNC();
            ZPI_SERVERS_SOAStub.String strJson = new ZPI_SERVERS_SOAStub.String();
            strJson.setString(in_json != null ? in_json.toJSONString() : "");
            async.setIN_JSON(strJson);
            ZPI_SERVERS_SOAStub.ZIF_DATA_TO_SAP_SYNCResponse response = stub.zIF_DATA_TO_SAP_SYNC(async);
            head.setSuccess(true);
            head.setMessage(response.getOUT_JSON().toString());
            stub._getServiceClient().cleanupTransport();
            stub._getServiceClient().cleanup();
            stub.cleanup();
            stub = null;
        } catch (RemoteException e) {
            head.setSuccess(false);
            head.setMessage(e.getMessage());
            log.error(e.getMessage(), e);
        }
        return head;
    }
}
