package com.biz.crm.business.common.base.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author huxml
 */
@Data
@ApiModel(value = "ComboTree")
public class ComboTree implements Serializable {

    @ApiModelProperty(value = "主键")
    private String id;
    @ApiModelProperty(value = "父节点")
    private String pid;
    @ApiModelProperty(value = "节点名称")
    private String text;
    @ApiModelProperty(value = "节点图标")
    private String iconCls;
    @ApiModelProperty(value = "是否勾选")
    private Boolean checked = false;
    @ApiModelProperty(value = "其他参数")
    private Map<String, Object> attributes;
    @ApiModelProperty(value = "子节点")
    private List<ComboTree> children;
    @ApiModelProperty(value = "是否展开")
    private String state = "open";

}
