package com.biz.crm.business.common.base.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @CLASS_DESCRIBE: 线程池配置
 * @AUTHOR: create by zkey on 2022-12-12
 */
@EnableAsync
@Configuration
@ComponentScan(basePackages = {"com.biz.crm.**"})
public class ThreadPoolTaskExecutorConfig {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolTaskExecutorConfig.class);

    @Bean("applicationTasksExecutor")
    public ThreadPoolTaskExecutor getExecutor(){
        logger.info("start executor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        //配置核心线程数
        executor.setCorePoolSize(10);
        //配置最大线程数
        executor.setMaxPoolSize(20);
        //配置队列大小
        executor.setQueueCapacity(512);
        //配置线程池中的线程的名称前缀
        executor.setThreadNamePrefix("CRM-EXECUTOR-");
        executor.setKeepAliveSeconds(60);

        // rejection-policy：当pool已经达到max size的时候，如何处理新任务
        // CALLER_RUNS：不在新线程中执行任务，而是有调用者所在的线程来执行
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        //执行初始化
        executor.initialize();
        return executor;
    }
}
