package com.biz.crm.business.common.base.eunm;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 流程状态枚举
 *
 * @author jerry7
 */
@Getter
@AllArgsConstructor
public enum ProcessStatusEnum {
    START("0", "0", "发起流程", "0"),
    PREPARE("1", "1", "待提交", "1"),
    COMMIT("2", "2", "审批中", "2"),
    PASS("3", "3", "审批通过", "3"),
    REJECT("4", "4", "驳回", "4"),
    RECOVER("5", "5", "追回", "5"),
    COLSE("6", "6", "关闭", "6");
    /**
     * 系统key
     */
    private final String key;
    /**
     * 字典编码
     */
    private final String dictCode;
    /**
     * 字典值
     */
    private final String value;
    /**
     * 字典排序
     */
    private final String order;

    /**
     * 根据编码返回流程状态名称
     *
     * @param key
     * @return
     */
    public static String getStatusNameByKey(String key) {
        if (Objects.nonNull(key)) {
            ProcessStatusEnum[] values = ProcessStatusEnum.values();
            for (ProcessStatusEnum statusEnum : values) {
                if (statusEnum.getKey().equals(key)) {
                    return statusEnum.getValue();
                }
            }
        }
        return null;
    }

    /**
     * 根据编码校验状态值是否存在
     *
     * @param key
     * @return
     */
    public static boolean checkKeyExist(String key) {

        ProcessStatusEnum[] values = ProcessStatusEnum.values();
        for (ProcessStatusEnum statusEnum : values) {
            if (statusEnum.getKey().equals(key)) {
                return true;
            }
        }
        return false;
    }

}
