/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.aspect;

import com.biz.crm.business.common.base.aop.RequestControl;
import com.biz.crm.business.common.base.config.RequestControlProperties;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RequestControlAspect {
    private final RequestControlProperties props;
    private final RedisTemplate<String, Object> redisTemplate;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Around(value="@annotation(requestControl)")
    public Object around(ProceedingJoinPoint pjp, RequestControl requestControl) throws Throwable {
        String requestId = this.getRequestId();
        String limitKey = this.props.getLimit().getKeyPrefix() + requestId;
        if (this.props.getLimit().isEnabled()) {
            Long count = this.redisTemplate.opsForValue().increment((Object)limitKey);
            if (count != null && count == 1L) {
                this.redisTemplate.expire((Object)limitKey, (long)this.props.getLimit().getExpireSeconds(), TimeUnit.SECONDS);
            } else if (count != null && count > (long)this.props.getLimit().getMaxCount()) {
                throw new RuntimeException("\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41");
            }
        }
        String idempotentKey = "idem:" + requestId;
        Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)idempotentKey, (Object)"1", (long)this.props.getIdempotentExpireSeconds(), TimeUnit.SECONDS);
        if (Boolean.FALSE.equals(locked)) {
            throw new RuntimeException("\u91cd\u590d\u8bf7\u6c42\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        Future<Object> future = this.executor.submit(() -> {
            try {
                return pjp.proceed();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        try {
            return future.get(this.props.getTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new TimeoutException("\u8bf7\u6c42\u8d85\u65f6\uff1a" + this.props.getTimeoutSeconds() + " \u79d2");
        }
    }

    private String getRequestId() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String token = request.getHeader("X-Request-ID");
        return StringUtils.hasText((String)token) ? token : DigestUtils.md5DigestAsHex((byte[])UUID.randomUUID().toString().getBytes());
    }

    public RequestControlAspect(RequestControlProperties props, RedisTemplate<String, Object> redisTemplate) {
        this.props = props;
        this.redisTemplate = redisTemplate;
    }
}

