/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public class ImageCompressor {
    public static byte[] compressToMax30KB(byte[] originalImageBytes) {
        BufferedImage bufferedImage;
        if (originalImageBytes == null || originalImageBytes.length == 0) {
            throw new IllegalArgumentException("\u539f\u59cb\u56fe\u7247\u5b57\u8282\u4e3a\u7a7a");
        }
        int maxSize = 30720;
        double quality = 1.0;
        int width = 500;
        int height = 500;
        byte[] result = originalImageBytes;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(originalImageBytes);){
            bufferedImage = ImageIO.read(bais);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25", e);
        }
        for (int attempt = 0; attempt < 20; ++attempt) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).size(width, height).outputQuality(quality).outputFormat("jpg").toOutputStream((OutputStream)outputStream);
                byte[] compressed = outputStream.toByteArray();
                if (compressed.length <= 30720) {
                    result = compressed;
                    break;
                }
                if (quality > 0.1) {
                    quality -= 0.1;
                    continue;
                }
                width = (int)((double)width * 0.9);
                height = (int)((double)height * 0.9);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("\u538b\u7f29\u56fe\u7247\u5931\u8d25", e);
            }
        }
        return result;
    }
}

