/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.util;

import com.biz.crm.business.common.base.util.DateStringDealUtil;
import com.google.common.collect.Maps;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.CollectionUtils;

public class ObjectConvertStringUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectConvertStringUtil.class);
    private static final String END_STR = "end";
    private static final String END_STR_UP = "End";

    public static <T> void fillObjectListStrProperties(List<T> list, Class<T> cls) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(cls);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        Map<String, Field> dateFieldMap = ObjectConvertStringUtil.getPropertyFieldMap(cls);
        for (T t : list) {
            ObjectConvertStringUtil.fillObjectStrProperties(t, dateFieldMap, propertyMap);
        }
    }

    public static <T> void fillObjectStrProperties(T t, Class<T> cls) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(cls);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        ObjectConvertStringUtil.fillObjectStrProperties(t, cls, propertyMap);
    }

    public static <T> void fillObjectStrProperties(T t, Class<T> cls, Map<String, PropertyDescriptor> propertyMap) {
        if (null == t) {
            return;
        }
        Map<String, Field> dateFieldMap = ObjectConvertStringUtil.getPropertyFieldMap(cls);
        ObjectConvertStringUtil.fillObjectStrProperties(t, dateFieldMap, propertyMap);
    }

    public static <T> void fillObjectStrProperties(T t, Map<String, Field> dateFieldMap, Map<String, PropertyDescriptor> propertyMap) {
        if (null == t) {
            return;
        }
        for (Map.Entry<String, PropertyDescriptor> entry : propertyMap.entrySet()) {
            String fieldName;
            String strPropertyName;
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (BigDecimal.class != propertyDescriptor.getPropertyType() && Integer.class != propertyDescriptor.getPropertyType() && Date.class != propertyDescriptor.getPropertyType() || !propertyMap.containsKey(strPropertyName = (fieldName = propertyDescriptor.getName()) + "Str")) continue;
            try {
                Object propertyValue = propertyDescriptor.getReadMethod().invoke(t, new Object[0]);
                if (null == propertyValue) continue;
                String strValue = null;
                if (propertyValue instanceof Date) {
                    Field declaredField = dateFieldMap.get(fieldName);
                    DateTimeFormat dateTimeFormat = declaredField.getDeclaredAnnotation(DateTimeFormat.class);
                    if (null == dateTimeFormat) continue;
                    String dateTimeFormatPattern = "yyyy-MM-dd HH:mm:ss";
                    if (StringUtils.isNotEmpty((CharSequence)dateTimeFormat.pattern())) {
                        dateTimeFormatPattern = dateTimeFormat.pattern();
                    }
                    strValue = DateStringDealUtil.getDateFormat(dateTimeFormatPattern).format(propertyValue);
                } else {
                    strValue = propertyValue.toString();
                }
                PropertyDescriptor strPropertyDescriptor = propertyMap.get(strPropertyName);
                strPropertyDescriptor.getWriteMethod().invoke(t, strValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("\u5c5e\u6027[" + fieldName + "]\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static <T> void convertObjectListStrProperties(List<T> list, Class<T> cls) {
        ObjectConvertStringUtil.convertObjectListStrProperties(list, cls, false);
    }

    public static <T> void convertObjectListStrProperties(List<T> list, Class<T> cls, Integer scale) {
        ObjectConvertStringUtil.convertObjectListStrProperties(list, cls, scale, false, null);
    }

    public static <T> void convertObjectListStrProperties(List<T> list, Class<T> cls, boolean throwException) {
        ObjectConvertStringUtil.convertObjectListStrProperties(list, cls, false, null);
    }

    public static <T> void convertObjectListStrProperties(List<T> list, Class<T> cls, boolean throwException, Map<String, String> fieldTitleMap) {
        ObjectConvertStringUtil.convertObjectListStrProperties(list, cls, null, false, null);
    }

    public static <T> void convertObjectListStrProperties(List<T> list, Class<T> cls, Integer scale, boolean throwException, Map<String, String> fieldTitleMap) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(cls);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        Map<String, Field> dateFieldMap = ObjectConvertStringUtil.getPropertyFieldMap(cls);
        for (T t : list) {
            ObjectConvertStringUtil.convertObjectListStrProperties(t, dateFieldMap, propertyMap, scale, throwException, fieldTitleMap);
        }
    }

    public static <T> void convertObjectListStrProperties(T t, Class<T> cls) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(cls);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        ObjectConvertStringUtil.convertObjectListStrProperties(t, cls, propertyMap, false);
    }

    public static <T> void convertObjectListStrProperties(T t, Class<T> cls, Map<String, PropertyDescriptor> propertyMap, boolean throwException) {
        ObjectConvertStringUtil.convertObjectListStrProperties(t, cls, propertyMap, throwException, null);
    }

    public static <T> void convertObjectListStrProperties(T t, Class<T> cls, Map<String, PropertyDescriptor> propertyMap, boolean throwException, Map<String, String> fieldTitleMap) {
        ObjectConvertStringUtil.convertObjectListStrProperties(t, cls, propertyMap, null, throwException, fieldTitleMap);
    }

    public static <T> void convertObjectListStrProperties(T t, Class<T> cls, Map<String, PropertyDescriptor> propertyMap, Integer scale, boolean throwException, Map<String, String> fieldTitleMap) {
        Map<String, Field> dateFieldMap = ObjectConvertStringUtil.getPropertyFieldMap(cls);
        ObjectConvertStringUtil.convertObjectListStrProperties(t, dateFieldMap, propertyMap, scale, throwException, fieldTitleMap);
    }

    public static <T> void convertObjectListStrProperties(T t, Map<String, Field> dateFieldMap, Map<String, PropertyDescriptor> propertyMap, Integer scale, boolean throwException, Map<String, String> fieldTitleMap) {
        if (null == t) {
            return;
        }
        for (Map.Entry<String, PropertyDescriptor> entry : propertyMap.entrySet()) {
            String originPropertyName;
            String fieldName;
            PropertyDescriptor propertyDescriptor = entry.getValue();
            if (propertyDescriptor.getPropertyType() != String.class || !(fieldName = propertyDescriptor.getName()).endsWith("Str") || !propertyMap.containsKey(originPropertyName = fieldName.substring(0, fieldName.indexOf("Str")))) continue;
            Object propertyValueObj = null;
            try {
                String propertyValue;
                propertyValueObj = propertyDescriptor.getReadMethod().invoke(t, new Object[0]);
                if (null == propertyValueObj || StringUtils.isEmpty((CharSequence)(propertyValue = propertyValueObj.toString().trim()))) continue;
                Comparable<Integer> originValue = null;
                PropertyDescriptor originPropertyDescriptor = propertyMap.get(originPropertyName);
                originPropertyDescriptor.getPropertyType();
                if (originPropertyDescriptor.getPropertyType() == Date.class) {
                    Field declaredField = dateFieldMap.get(originPropertyDescriptor.getName());
                    DateTimeFormat dateTimeFormat = declaredField.getDeclaredAnnotation(DateTimeFormat.class);
                    if (null == dateTimeFormat) continue;
                    String dateTimeFormatPattern = "yyyy-MM-dd HH:mm:ss";
                    if (StringUtils.isNotEmpty((CharSequence)dateTimeFormat.pattern())) {
                        dateTimeFormatPattern = dateTimeFormat.pattern();
                    }
                    if (dateTimeFormatPattern.equals("yyyy-MM-dd") && originPropertyName.contains(END_STR_UP) || originPropertyName.contains(END_STR)) {
                        dateTimeFormatPattern = "yyyy-MM-dd HH:mm:ss";
                        propertyValue = propertyValue + " " + " 23:59:59";
                    }
                    originValue = DateStringDealUtil.getDateFormat(dateTimeFormatPattern).parse(propertyValue);
                } else if (originPropertyDescriptor.getPropertyType() == Integer.class) {
                    originValue = Integer.valueOf(propertyValue);
                } else if (originPropertyDescriptor.getPropertyType() == BigDecimal.class) {
                    originValue = null == scale ? new BigDecimal(propertyValue) : new BigDecimal(propertyValue).setScale((int)scale, RoundingMode.HALF_UP);
                }
                originPropertyDescriptor.getWriteMethod().invoke(t, originValue);
            }
            catch (IllegalAccessException | NumberFormatException | InvocationTargetException | ParseException e) {
                log.error("\u5c5e\u6027[" + fieldName + "][" + propertyValueObj + "]\u8f6c\u6362\u5931\u8d25");
                log.error(e.getMessage(), (Throwable)e);
                if (!throwException) continue;
                String fieldTitle = fieldName;
                if (null != fieldTitleMap && fieldTitleMap.containsKey(fieldName)) {
                    fieldTitle = fieldTitleMap.get(fieldName);
                }
                throw new IllegalArgumentException("\u5c5e\u6027[" + fieldTitle + "][" + propertyValueObj + "]\u8f6c\u6362\u5931\u8d25");
            }
        }
    }

    public static Map<String, Field> getPropertyFieldMap(Class<?> clazz) throws BeansException {
        HashMap propertyFieldMap = Maps.newHashMap();
        return ObjectConvertStringUtil.getPropertyFieldMap(clazz, propertyFieldMap);
    }

    public static Map<String, Field> getPropertyFieldMap(Class<?> clazz, Map<String, Field> propertyFieldMap) throws BeansException {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            propertyFieldMap.put(declaredField.getName(), declaredField);
        }
        if (clazz.getSuperclass() != Object.class) {
            ObjectConvertStringUtil.getPropertyFieldMap(clazz.getSuperclass(), propertyFieldMap);
        }
        return propertyFieldMap;
    }
}

