/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.base.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisLockService {
    private static final Logger log = LoggerFactory.getLogger(RedisLockService.class);
    @Autowired(required=false)
    private RedissonClient redissonClient;
    private static final int THREE = 3;
    private static final int FIVE = 5;

    public void lock(String key) {
        Validate.notBlank((CharSequence)key, (String)"RedisLockService key is null!!", (Object[])new Object[0]);
        boolean result = this.tryLock(key, TimeUnit.MINUTES, 5L);
        Validate.isTrue((boolean)result, (String)("\u64cd\u4f5c\u4eba\u5458\u8fc7\u591a,\u52a0\u9501[" + key + "]\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5!"), (Object[])new Object[0]);
    }

    public void lock(String key, TimeUnit unit, long lockTime) {
        Validate.notBlank((CharSequence)key, (String)"RedisLockService key is null!!", (Object[])new Object[0]);
        boolean result = this.tryLock(key, unit, lockTime);
        Validate.isTrue((boolean)result, (String)("\u64cd\u4f5c\u4eba\u5458\u8fc7\u591a,\u52a0\u9501[" + key + "]\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5!"), (Object[])new Object[0]);
    }

    public void lock(String key, TimeUnit unit, long lockTime, long waitTime) {
        Validate.notBlank((CharSequence)key, (String)"RedisLockService key is null!!", (Object[])new Object[0]);
        boolean result = this.tryLock(key, unit, lockTime, waitTime);
        Validate.isTrue((boolean)result, (String)("\u64cd\u4f5c\u4eba\u5458\u8fc7\u591a,\u52a0\u9501[" + key + "]\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5!"), (Object[])new Object[0]);
    }

    public boolean tryLock(String key, TimeUnit unit, long lockTime) {
        return this.tryLock(key, unit, lockTime, 0L);
    }

    public boolean tryLock(String key, TimeUnit unit, long lockTime, long waitTime) {
        Validate.notBlank((CharSequence)key, (String)"RedisLockService key must not be empty!!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)unit), (String)"RedisLockService unit must not be empty!!", (Object[])new Object[0]);
        Validate.isTrue((lockTime > 0L ? 1 : 0) != 0, (String)"RedisLockService lockTime must be greater than 0!!", (Object[])new Object[0]);
        Validate.isTrue((waitTime >= 0L ? 1 : 0) != 0, (String)"RedisLockService waitTime must be greater than or equal to 0!!", (Object[])new Object[0]);
        boolean result = false;
        waitTime *= 1000L;
        RLock rLock = this.createLock(key);
        try {
            result = rLock.tryLock(waitTime, lockTime, unit);
        }
        catch (InterruptedException e) {
            log.error("\u91ca\u653e\u9501\u5931\u8d25\uff0c\u9501\uff1a{}", (Object)key);
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected RLock createLock(String key) {
        return this.redissonClient.getLock(key);
    }

    public void unlock(String key) {
        Validate.notBlank((CharSequence)key, (String)"RedisLockService key is null!!", (Object[])new Object[0]);
        String name = "";
        try {
            RLock lock = this.createLock(key);
            if (null == lock) {
                return;
            }
            name = lock.getName();
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u91ca\u653e\u9501\u5931\u8d25\uff0c\u9501\uff1a{} {}", (Object)key, (Object)name);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isLock(String key) {
        Validate.notBlank((CharSequence)key, (String)"RedisLockService key is null!!", (Object[])new Object[0]);
        RLock rlock = this.redissonClient.getLock(key);
        return rlock.isLocked();
    }

    public boolean isBatchLock(String prefix, List<String> keyList) {
        Validate.notBlank((CharSequence)prefix, (String)"RedisLockService key prefix is null!!", (Object[])new Object[0]);
        for (String key : keyList) {
            if (!this.isLock(prefix + key)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchLock(String prefix, List<String> keyList, TimeUnit timeUnit, int time) {
        Validate.notNull((Object)prefix, (String)"\u52a0\u9501\u5931\u8d25\uff0c\u9501\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(keyList)) {
            throw new RuntimeException("\u52a0\u9501\u5931\u8d25\uff0ckey\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.SECONDS;
        }
        if (time <= 0) {
            time = 3;
        }
        boolean isLock = true;
        ArrayList<String> successKeys = new ArrayList<String>();
        try {
            for (String key : keyList) {
                isLock = this.tryLock(prefix + key, timeUnit, time);
                if (!isLock) {
                    boolean bl = false;
                    return bl;
                }
                successKeys.add(key);
            }
        }
        finally {
            if (!isLock && !CollectionUtils.isEmpty(successKeys)) {
                this.batchUnLock(prefix, successKeys);
            }
        }
        return true;
    }

    public void batchUnLock(String prefix, List<String> keyList) {
        if (CollectionUtils.isEmpty(keyList)) {
            throw new RuntimeException("\u89e3\u9501\u5931\u8d25\uff0ckey\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        keyList.forEach(key -> this.unlock(prefix + key));
    }
}

