package com.biz.crm.business.common.base.config;

import com.biz.crm.business.common.base.constant.BusinessConstant;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.security.local.utils.JwtUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.RestTemplate;

import java.util.Objects;

/**
 * @author huxmld
 */
@Configuration
public class NebulaEventRestTemplateConfig {

    @Autowired(required = false)
    private SimpleSecurityProperties simpleSecurityProperties;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @LoadBalanced
    @Bean({"nebulaEventRestTemplate"})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        //nebula event请求之前从内存中获取设置jwt
        restTemplate.setInterceptors(Lists.newArrayList((request, body, execution) -> {
            HttpHeaders headers = request.getHeaders();
            if (!headers.containsKey(BusinessConstant.JWT)) {
                AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
                if (Objects.isNull(userIdentity)) {
                    loginUserService.refreshAuthentication(null);
                    userIdentity = loginUserService.getAbstractLoginUser();
                }
                String jwtContent = JwtUtils.encode(userIdentity, 0, simpleSecurityProperties.getSecretKey());
                headers.add(BusinessConstant.JWT, jwtContent);
            }
            return execution.execute(request, body);
        }));
        return restTemplate;
    }


}
