package com.biz.crm.business.common.base.util;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

/**
 * @Description
 * @Author lifei
 * @Date 2025/8/22 17:33
 **/
public class CrmBeanCopyUtils {

    public static void copyOnlyIfTargetIsNull(Object source, Object target) {
        BeanWrapper srcWrapper = new BeanWrapperImpl(source);
        BeanWrapper trgWrapper = new BeanWrapperImpl(target);

        for (java.beans.PropertyDescriptor pd : srcWrapper.getPropertyDescriptors()) {
            String propertyName = pd.getName();
            Object sourceValue = srcWrapper.getPropertyValue(propertyName);
            Object targetValue = trgWrapper.getPropertyValue(propertyName);

            if (targetValue == null && sourceValue != null) {
                trgWrapper.setPropertyValue(propertyName, sourceValue);
            }
        }
    }
}
