package com.biz.crm.business.common.base.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 导出异常自动清理
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023-05-29 23:44
 */
@Configuration
@Data
public class ExportTaskConfig {

    /**
     * 是否开启导出异常自动清理
     * 默认开启
     */
    @Value("${export.task.is-open:true}")
    private Boolean isOpen;

    /**
     * 定时任务清理日志时间
     */
    @Value("${export.task.clean-cron:0 2/10 * * * ?}")
    private String cleanCron;

    /**
     * 默认清理2小时以前的
     */
    @Value("${export.task.save-hour:2}")
    private Integer saveHour;

    /**
     * 当前应用名称
     */
    @Value("${spring.application.name:default}")
    private String appName;

}
