package com.biz.crm.business.common.base.util;


import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * 认养一头牛 header 参数签名
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2024/5/21 17:30
 */
@Slf4j
public class SignHeaderUtil {

    /**
     * 根据  AK+SK+接口地址 获取请求头部参数
     *
     * @param accessKey        ak
     * @param secretKey        sk
     * @param interfaceAddress 接口地址
     * @return
     */
    public static Map<String, String> getSignHeadMap(String accessKey, String secretKey, String interfaceAddress) {
        Map<String, String> headMap = Maps.newHashMap();
        headMap.put("version", "2.0.0");
        String timestampStr = System.currentTimeMillis() + "";
        String alg = "MD5";
        JSONObject authJson = new JSONObject();
        authJson.put("timestamp", timestampStr);
        authJson.put("appKey", accessKey);
        authJson.put("alg", alg);
        headMap.put("Authorization", signAuthorization(authJson.toJSONString(), interfaceAddress, secretKey));
        return headMap;
    }


    /**
     * 根据 头部参数+接口地址+SK 获取 Authorization
     *
     * @param headerJson       头部请求参数
     * @param interfaceAddress 接口地址
     * @param secretKey        sk
     * @return
     */
    public static String signAuthorization(String headerJson, String interfaceAddress, String secretKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n=====>    RySignHeaderUtil BASE64 key:     [").append(headerJson).append("]     <=====\n ");
        String base64Value = Base64.encode(headerJson, StandardCharsets.UTF_8);
        stringBuilder.append("=====>    RySignHeaderUtil base64Value:     [").append(headerJson).append("]     <=====\n");
        String md5Key = base64Value + interfaceAddress + secretKey;
        stringBuilder.append("=====>    RySignHeaderUtil md5Key:     [").append(headerJson).append("]     <=====\n");
        String md5Value = MD5.create().digestHex(md5Key, StandardCharsets.UTF_8).toUpperCase();
        stringBuilder.append("=====>    RySignHeaderUtil md5Value:     [").append(headerJson).append("]     <=====\n");
        log.info(stringBuilder.toString());
        return base64Value + "." + md5Value;
    }
}

