/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.rocketmq.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.biz.crm.business.common.rocketmq.config.RocketMqConfig;
import com.biz.crm.business.common.rocketmq.config.condition.AlibabaCondition;
import com.biz.crm.business.common.rocketmq.listener.GeneralMessageListener;
import com.biz.crm.business.common.rocketmq.util.AlibabaMqTopicAndTagUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.util.Assert;

@Conditional(value={AlibabaCondition.class})
public class RocketMqConsumerClient {
    private static final Logger log = LoggerFactory.getLogger(RocketMqConsumerClient.class);
    @Autowired(required=false)
    private RocketMqConfig rocketMqConfig;
    @Autowired(required=false)
    private GeneralMessageListener generalMessageListener;

    public ConsumerBean consumerClient() {
        ConsumerBean consumerBean = new ConsumerBean();
        Properties properties = this.rocketMqConfig.getMqProperty();
        properties.setProperty("MessageModel", "CLUSTERING");
        Assert.hasLength((String)this.rocketMqConfig.getGroupId(), (String)"\u6d88\u8d39\u8005GroupId\u4e0d\u80fd\u4e3a\u7a7a!");
        properties.setProperty("GROUP_ID", this.rocketMqConfig.getGroupId());
        properties.setProperty("PostSubscriptionWhenPull", "true");
        properties.setProperty("ConsumeThreadNums", "20");
        consumerBean.setProperties(properties);
        HashMap subscriptionTable = Maps.newHashMap();
        Map<String, Map<String, Set<String>>> topicMap = AlibabaMqTopicAndTagUtil.getTopicMap();
        if (CollectionUtil.isNotEmpty(topicMap)) {
            topicMap.forEach((topic, tagServiceMap) -> {
                if (CollectionUtil.isNotEmpty((Map)tagServiceMap)) {
                    Subscription orderSubscription = new Subscription();
                    orderSubscription.setTopic(topic);
                    orderSubscription.setExpression(String.join((CharSequence)"||", tagServiceMap.keySet()));
                    subscriptionTable.put(orderSubscription, this.generalMessageListener);
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Map)subscriptionTable)) {
            log.info("=====>\u963f\u91cc\u4e91rocketMq\u542f\u7528\u96c6\u7fa4\u6d88\u8d39\u8005{}", (Object)subscriptionTable);
            consumerBean.setSubscriptionTable((Map)subscriptionTable);
            consumerBean.start();
            return consumerBean;
        }
        log.warn("=====>\u963f\u91cc\u4e91rocketMq\u65e0\u96c6\u7fa4\u6d88\u8d39\u8005");
        consumerBean.shutdown();
        return null;
    }
}

